<?php

include('lib/ressources.php');
include('lib/graphPageFlowSampleCode.php');

if (sizeof($argv)<3)
{
	echo "Erreur : cette commande prend 2 arguments :\n- fichier JSON de données;\n- fichier de sortie pour le graphe.\n";
}
else
{
	$donnees=litFichierJson($argv[1]);
	if($donnees)
	{
		$durees=array();
		$reponse=array();
		$graphe=array();
		$graphe["class"]="go.GraphLinksMode";
		$graphe["copiesArrays"]="true";
		$graphe["copiesArrayObjects"]="true";
		$graphe["nodeDataArray"]=array();
		$graphe["linkDataArray"]=array();
		foreach($donnees['structure']['pages'] as $page) //pour toutes les pages de la leçon (contenu et questions)
		{
			$durees[$page["page"]["id"]]=array();
			$pageDescription=array(); 
			$pageDescription["key"]=$page["page"]["id"];
			$pageDescription["text"]=$page["page"]["title"];
			if($page['page']['typestring']=="Contenu")//changement de couleur selon le type de page
			{
				$pageDescription["category"]="Source";
			}
			else
			{
				$pageDescription["total"]=0;
				$pageDescription["correct"]=0;
			}
			array_push($graphe["nodeDataArray"],$pageDescription);
			foreach($page['answerids'] as $reponseId => $reponseValeur) //construction d'un tableau de liens vers les pages suivantes selon les réponses données aux questions
			{
				$reponseLien=array();
				$reponseLien["id"]=$reponseValeur;
				$reponseLien["lien"]=$page['jumps'][$reponseId];
				array_push($reponse, $reponseLien);
			}
		}
		//Ajout d'une dernière page pour la conclusion
		$durees[-9]=array();
		$pageFin=array();
		$pageFin["key"]=-9;
		$pageFin["text"]="Fin de la leçon";
		$pageFin["category"]="Source";
		array_push($graphe["nodeDataArray"],$pageFin);
		
		if($donnees['participants'])
		{
			foreach($donnees['participants'] as $participant) //pour tous les participants qui ont commencé la leçon
			{
				foreach($participant['tentatives'] as $tentative) //pour chaque tentative
				{
					$parcoursDuree=array(); 
					foreach($tentative['pages']['pages'] as $page) //pour toutes les pages de la leçon
					{
						$parcoursDuree[$page['timeseen']]=$page['pageid'];//collecte du moment où la page a été visionnée
						$idLien=lectureIdTableaulien($graphe['linkDataArray'], $page['pageid'], $page['nextpageid']);//récupération de l'id du lien depuis le tableau des liens
						$graphe['linkDataArray']=ajouteLien($graphe['linkDataArray'], $idLien, $page['pageid'], $page['nextpageid']);//collecte du lien vers la page suivante
					}
					foreach($tentative['questions']['attempts'] as $question)//pour toutes les questions de la leçon
					{
						$parcoursDuree[$question['timeseen']]=$question['pageid'];//collecte du moment où la question a été répondue
						$idNoeud=lectureIdTableauNoeud($graphe["nodeDataArray"], "key", $question['pageid']);
						$graphe["nodeDataArray"][$idNoeud]['total']++;
						if($question['correct'])
						{
							$graphe["nodeDataArray"][$idNoeud]['correct']++;
						}
						$pageReponse=lectureValeurTableau($reponse, $question['answerid'], "id", "lien", $question['pageid']);//récupération du lien en fonction de la réponse choisie
						switch($pageReponse) //gestion des liens pages suivante, précédente...
						{
							case 0: //cette page
								$pageReponse=$question['pageid'];
								break;
							case -1: //page suivante
								$pageReponse=$graphe["nodeDataArray"][$idNoeud+1]['key'];
								break;
							case -40:
								$pageReponse=$graphe["nodeDataArray"][$idNoeud-1]['key'];
								break;
						}
						$idLien=lectureIdTableaulien($graphe['linkDataArray'], $question['pageid'], $pageReponse);//récupération de l'id du lien depuis le tableau des liens
						$graphe['linkDataArray']=ajouteLien($graphe['linkDataArray'], $idLien, $question['pageid'], $pageReponse);//collecte du lien vers la page suivante
					}
					ksort($parcoursDuree); //remise dans l'ordre des pages et des questions selon le moment où elles ont été réalisées
					if($tentative['status']) //si la leçon est terminée
					{
						end($parcoursDuree);
						$lastElementKey=key($parcoursDuree);
						$parcoursDuree[$lastElementKey+1]=-9; //ajout de la dernière étape vers la fin de la leçon
					}
					$premierePage=1;
					foreach($parcoursDuree as $dureePage => $page) //calcul des durées
					{
						if($premierePage)//si première activité -> calcul avec le début la leçon
						{
							array_push($durees[$page], $dureePage-$tentative['start']);
							$premierePage=0;
						}					
						else
						{
							array_push($durees[$page], $dureePage-$dureePagePrecedente);
						}
						$dureePagePrecedente=$dureePage;
						$pagePrecedente=$page;
					}
				}
			}
		}
		foreach($graphe["nodeDataArray"] as $id => $info) //calcul de la durée médiane pour chaque page
		{
			$dureeMediane=0;
			if(sizeof($durees[$info['key']]))//s'il y a des durées enregistrées pour la page
			{
				$dureeMediane=calculeMediane($durees[$info['key']]);//calcul de la durée médiane
			}
			$score="";
			if(array_key_exists("total", $info))
			{
				$score="\nScore : " . $info['correct'] . " / " .$info['total'];
				unset($graphe['nodeDataArray'][$id]['total']);
				unset($graphe['nodeDataArray'][$id]['correct']);
			}
			$graphe["nodeDataArray"][$id]["text"]=$info["text"] . "\nDurée médiane : ". gmdate("H:i:s", $dureeMediane) . $score; //ajout de la durée médiane au texte
		}
		$lastPageIdArray=lectureIdTableauNoeud($graphe['nodeDataArray'], "key", -9);
		$graphe["nodeDataArray"][$lastPageIdArray]["text"]="Conclusion";
		$donneesGraphe=array('datasfordrawinggraph' => json_encode($graphe));
		$sortie=strtr($html, $donneesGraphe);
		ecritFichier($sortie, $argv[2]);
	}
	else
	{
		echo("Erreur : les données n'ont pas pu être lues dans le fichier JSON d'entrée.\n");
	}
}
?>