<?php

$html= <<<EOT
  <!DOCTYPE html>
  <html lang="en">
  <body>
  <script src="../lib/go/go.js"></script>
  <p>
    This is a minimalist HTML and JavaScript skeleton of the GoJS Sample
    <a href="https://gojs.net/latest/samples/pageFlow.html">pageFlow.html</a>. It was automatically generated from a button on the sample page,
    and does not contain the full HTML. It is intended as a starting point to adapt for your own usage.
    For many samples, you may need to inspect the
    <a href="https://github.com/NorthwoodsSoftware/GoJS/blob/master/samples/pageFlow.html">full source on Github</a>
    and copy other files or scripts.
  </p>
  <div id="allSampleContent" class="p-4 w-full">
<script id="code">
  var isDarkMode = false; // is accessed by html elements (button) so must be declared in script scope
  function init() {

    // Since 2.2 you can also author concise templates with method chaining instead of GraphObject.make
    // For details, see https://gojs.net/latest/intro/buildingObjects.html
    const $ = go.GraphObject.make;  // for conciseness in defining templates

    // colors are almost entirely defined up here to allow for easier theming
    var yellow = "#FFB400"

    var green = "#7FB800";
    var blue = "#00A6ED";
    var red = "#D73909";
    var white = "#DCE9F9";

    var blueShadow = "#407090";
    var greenShadow = "#406050";
    var yellowShadow = "#804040";
    var redShadow = "#705020";
    var whiteShadow = "#404050";

    var selectColor = "dodgerBlue";
    var undesiredEventTextColor = "whitesmoke";

    var lineColor = "#0D2C54";
    var commentLineColor = "darkgreen";

    var darkModeBackgroundColor = "#06162a";
    var lightModeBackgroundColor = "#FFFFFF";

    var bigfont = "bold 13pt Helvetica, Arial, sans-serif";
    var smallfont = "bold 11pt Helvetica, Arial, sans-serif";

    // Common text styling
    function textStyle() {
      return {
        margin: 10,
        wrap: go.TextBlock.WrapFit,
        textAlign: "center",
        editable: true,
        font: bigfont
      }
    }

    myDiagram =
      new go.Diagram("myDiagramDiv",
        {
          // have mouse wheel events zoom in and out instead of scroll up and down
          "toolManager.mouseWheelBehavior": go.ToolManager.WheelZoom,
          initialAutoScale: go.Diagram.Uniform,
          "linkingTool.direction": go.LinkingTool.ForwardsOnly,
          layout: $(go.LayeredDigraphLayout,
            {
              isInitial: false, isOngoing: false,
              layerSpacing: 100,
              alignOption: go.LayeredDigraphLayout.AlignAll
            }),
          "undoManager.isEnabled": true,
        });

    // when the document is modified, add a "*" to the title and enable the "Save" button
    myDiagram.addDiagramListener("Modified", e => {
      var button = document.getElementById("SaveButton");
      if (button) button.disabled = !myDiagram.isModified;
      var idx = document.title.indexOf("*");
      if (myDiagram.isModified) {
        if (idx < 0) document.title += "*";
      } else {
        if (idx >= 0) document.title = document.title.slice(0, idx);
      }
    });

    var defaultAdornment =
      $(go.Adornment, "Spot",
        $(go.Panel, "Auto",
          $(go.Shape, { fill: null, stroke: selectColor, strokeWidth: 3 }),
          $(go.Placeholder)),
        // the button to create a "next" node, at the top-right corner
        $("Button",
          {
            alignment: new go.Spot(1, 0, -5, 5),
            click: addNodeAndLink
          },  // this function is defined below
          new go.Binding("visible", "", a => !a.diagram.isReadOnly).ofObject(),
          $(go.Shape, "PlusLine", { desiredSize: new go.Size(6, 6) })
        )
      );

    // define the Node template
    myDiagram.nodeTemplate =
      $(go.Node, "Auto",
        {
          selectionAdornmentTemplate: defaultAdornment,
          isShadowed: true,
          shadowBlur: 2,
          shadowColor: yellowShadow,
          shadowOffset: new go.Point(4, 6)
        },
        new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
        $(go.Shape, "Rectangle",
          {
            fill: yellow, stroke: "rgba(0, 0, 0, 0)",
            portId: "", fromLinkable: true, toLinkable: true, cursor: "pointer",
            toEndSegmentLength: 50, fromEndSegmentLength: 40
          },
        ),
        $(go.TextBlock, "Page",
          {
            margin: 10,
            font: bigfont,
            editable: true
          },
          new go.Binding("text", "text").makeTwoWay())
          );

    myDiagram.nodeTemplateMap.add("Source",
      $(go.Node, "Auto",
      {
        isShadowed: true,
        shadowBlur: 2,
        shadowColor: blueShadow,
        shadowOffset: new go.Point(4, 6)
      },
        new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
        $(go.Shape, "RoundedRectangle",
          {
            name: "SHAPE",
            fill: blue, stroke: "rgba(0, 0, 0, 0)",
            portId: "", fromLinkable: true, cursor: "pointer", fromEndSegmentLength: 40
          },
          new go.Binding("fill", "color")),
        $(go.TextBlock, "Source", textStyle(),
          new go.Binding("text", "text").makeTwoWay())
      ));

    myDiagram.nodeTemplateMap.add("DesiredEvent",
      $(go.Node, "Auto",
        {
          isShadowed: true,
          shadowBlur: 2,
          shadowColor: greenShadow,
          shadowOffset: new go.Point(4, 6)
        },
        new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
        $(go.Shape, "RoundedRectangle",
          { fill: green, stroke: null, portId: "", toLinkable: true, toEndSegmentLength: 50 },
          new go.Binding("fill", "color")),
        $(go.TextBlock, "Success!", textStyle(),
          new go.Binding("text", "text").makeTwoWay())
      ));

    // Undesired events have special adornments that allows adding and removing additional "reasons"
    var UndesiredEventAdornmentModify =
      $(go.Adornment, "Spot",
        $(go.Panel, "Auto",
          $(go.Shape, { fill: null, stroke: selectColor, strokeWidth: 4 }),
          $(go.Placeholder)),
        // the button to create a new reason, at the bottom-left corner
        $("Button",
          {
            alignment: new go.Spot(1, 1, -5, -5),
            click: addReason
          },  // this function is defined below
          new go.Binding("visible", "", a => !a.diagram.isReadOnly).ofObject(),
          $(go.Shape, "TriangleDown", { desiredSize: new go.Size(10, 10) })
        ),
        //the button to remove the most recent reason, above the "create" button
        $("Button",
          {
            alignment: new go.Spot(1, 1, -5, -22),
            click: removeReason
          }, //this function is also defined below
          new go.Binding("visible", "", a => !a.diagram.isReadOnly).ofObject(),
          $(go.Shape, "TriangleUp", { desiredSize: new go.Size(10, 10) })
        )
      );

    var reasonTemplate = $(go.Panel, "Horizontal",
      $(go.TextBlock, "•",
        {
          margin: 4,
          stroke: undesiredEventTextColor,
          font: smallfont
        }),
      $(go.TextBlock, "Reason",
        {
          margin: 4,
          maxSize: new go.Size(200, NaN),
          wrap: go.TextBlock.WrapFit,
          stroke: undesiredEventTextColor,
          editable: true,
          font: smallfont
        },
        new go.Binding("text", "text").makeTwoWay())
    );

    myDiagram.nodeTemplateMap.add("UndesiredEvent",
      $(go.Node, "Auto",
        {
          isShadowed: true,
          shadowBlur: 2,
          shadowColor: redShadow,
          shadowOffset: new go.Point(4, 6)
        },
        new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
        { selectionAdornmentTemplate: UndesiredEventAdornmentModify },
        $(go.Shape, "RoundedRectangle",
          { fill: red, stroke: null, portId: "", toLinkable: true, toEndSegmentLength: 50 }),
        $(go.Panel, "Vertical", { defaultAlignment: go.Spot.Top },

          $(go.TextBlock, "Drop", textStyle(),
            {
              stroke: undesiredEventTextColor,
              minSize: new go.Size(80, NaN)
            },
            new go.Binding("text", "text").makeTwoWay()),

            $(go.Panel, "Vertical",
            {
              defaultAlignment: go.Spot.TopLeft,
              itemTemplate: reasonTemplate
            },
            new go.Binding("itemArray", "reasonsList").makeTwoWay()
          )
        )
      ));

    myDiagram.nodeTemplateMap.add("Comment",
      $(go.Node, "Auto",
        new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
        $(go.Shape, "Rectangle",
          { portId: "", fill: white, stroke: null, fromLinkable: true }),
          $(go.TextBlock, "A comment",
          {
            margin: 10,
            maxSize: new go.Size(200, NaN),
            wrap: go.TextBlock.WrapFit,
            editable: true,
            font: smallfont
          },
          new go.Binding("text", "text").makeTwoWay())
        // no ports, because no links are allowed to connect with a comment
      ));

    // clicking the add button on an UndesiredEvent node inserts a new text object into the panel
    function addReason(e, obj) {
      var adorn = obj.part;
      if (adorn === null) return;
      e.handled = true;
      var arr = adorn.adornedPart.data.reasonsList;
      myDiagram.startTransaction("add reason");
      myDiagram.model.addArrayItem(arr, {});
      myDiagram.commitTransaction("add reason");
    }

    // clicking the remove button will remove the most recent text object added to the panel
    function removeReason(e, obj) {
        var adorn = obj.part;
        if (adorn === null) return;
        e.handled = true;
        var arr = adorn.adornedPart.data.reasonsList;
        myDiagram.startTransaction("remove reason");
        myDiagram.model.removeArrayItem(arr, arr.length - 1);
        myDiagram.commitTransaction("remove reason");
    }

    // clicking the button of a default node inserts a new node to the right of the selected node,
    // and adds a link to that new node
    function addNodeAndLink(e, obj) {
      var adorn = obj.part;
      if (adorn === null) return;
      e.handled = true;
      var diagram = adorn.diagram;
      diagram.startTransaction("Add State");
      // get the node data for which the user clicked the button
      var fromNode = adorn.adornedPart;
      var fromData = fromNode.data;
      // create a new "State" data object, positioned off to the right of the adorned Node
      var toData = { text: "new" };
      var p = fromNode.location;
      toData.loc = p.x + 200 + " " + p.y;  // the "loc" property is a string, not a Point object
      // add the new node data to the model
      var model = diagram.model;
      model.addNodeData(toData);
      // create a link data from the old node data to the new node data
      var linkdata = {};
      linkdata[model.linkFromKeyProperty] = model.getKeyForNodeData(fromData);
      linkdata[model.linkToKeyProperty] = model.getKeyForNodeData(toData);
      // and add the link data to the model
      model.addLinkData(linkdata);
      // select the new Node
      var newnode = diagram.findNodeForData(toData);
      diagram.select(newnode);
      diagram.commitTransaction("Add State");
    }

  
	  myDiagram.linkTemplate =
        $(go.Link,  // the whole link panel
		{ curve: go.Link.Bezier,
          toShortLength: 5,
          fromSpot: go.Spot.Right,
          toSpot: go.Spot.Left
        },
          $(go.Shape,  // the link shape
            { stroke: "black" }),
          $(go.Shape,  // the arrowhead
            { toArrow: "Kite", stroke: null }),
          $(go.Panel, "Auto",
            $(go.Shape,  // the label background, which becomes transparent around the edges
              {
                fill: $(go.Brush, "Radial", { 0: "rgb(240, 240, 240)", 0.3: "rgb(240, 240, 240)", 1: "rgba(240, 240, 240, 0)" }),
                stroke: null
              }),
            $(go.TextBlock,  // the label text
              {
                textAlign: "center",
                font: "10pt helvetica, arial, sans-serif",
                stroke: "#555555",
                margin: 4
              },
              new go.Binding("text", "text"))
          )
        );
	  
	  

    // comments will have different links
    myDiagram.linkTemplateMap.add("Comment",
      $(go.Link,
        {
          fromSpot: go.Spot.Center,
          toSpot: go.Spot.Center
        },
        $(go.Shape, { strokeWidth: 1.5, stroke: "darkgreen" })
      )
    );

    // when a new link is created, determine what template to use
    myDiagram.addDiagramListener("LinkDrawn", e => {
      var link = e.subject;
      if(link.fromNode.category === "Comment") {
        link.category = "Comment";
      }
    });

    var palette =
      new go.Palette("myPaletteDiv",  // create a new Palette in the HTML DIV element
        {
          // share the template map with the Palette
          nodeTemplateMap: myDiagram.nodeTemplateMap,
          autoScale: go.Diagram.Uniform  // everything always fits in viewport
        });

    palette.model.nodeDataArray = [
      { category: "Source" },
      {}, // default node
      { category: "DesiredEvent" },
      { category: "UndesiredEvent", reasonsList: [{}] },
      { category: "Comment" }
    ];

    // read in the JSON-format data from the "mySavedModel" element
    load();
    layout();
  }

  function layout() {
    myDiagram.layoutDiagram(true);
  }

  // Show the diagram's model in JSON format
  function save() {
    document.getElementById("mySavedModel").value = myDiagram.model.toJson();
    myDiagram.isModified = false;
  }

  function load() {
    myDiagram.model = go.Model.fromJson(document.getElementById("mySavedModel").value);
  }
  window.addEventListener('DOMContentLoaded', init);


</script>

<div id="sample">
<div style="width: 100%; display: flex; justify-content: space-between; background-color: #FCFCFC">
    <div id="myDiagramDiv" style="flex-grow: 1; height: 800px; border: 1px solid black; position: relative; cursor: auto;"><canvas tabindex="0" style="position: absolute; top: 0px; left: 0px; z-index: 2; user-select: none; touch-action: none; width: 952px; cursor: auto;" width="952" height="800"></canvas><div style="position: absolute; overflow: auto; width: 952px; height: 800px; z-index: 1;"></div>
</div>
</div>
</div>
<p>
<button id="SaveButton" onclick="save()" disabled="">Save</button>
<button onclick="load()">Load</button>
<button onclick="layout()">Layout</button>
</p>
Diagram Model saved in JSON format:
<br>
<textarea id="mySavedModel" style="width:100%;height:500px">
datasfordrawinggraph
</textarea>
<p class="text-xs">GoJS version 2.3.13. Copyright 1998-2023 by Northwoods Software.</p></div>
    <p><a href="https://github.com/NorthwoodsSoftware/GoJS/blob/master/samples/pageFlow.html" target="_blank">View this sample page's source on GitHub</a></p></div>
  </body>
  </html>
EOT;
?>