<?php
/*variables*/

$url="https://mm2024.univ-amu.fr/webservice/rest/server.php?wstoken=4091ec62c9a7de0f0c7186e44de04396";
$format="&moodlewsrestformat=json";

/*Fonctions sur les fichiers*/

function ecritFichier($message, $fichier) //écriture d'un fichier
{
	if(file_exists($fichier))
	{
		$partiesNom=explode(".", $fichier);
		$nouveauNom="";
		$i=1;
		$max=(sizeof($partiesNom))-1;
		foreach($partiesNom as $partie)
		{
			if($i==1)
			{
				$nouveauNom=$partie;
			}
			else
			{
				$nouveauNom.='.' . $partie;
			}
			if($i==$max)
			{
				$nouveauNom.=date("Y-m-d-H-i-s");
			}
			$i++;
		}
		rename($fichier, $nouveauNom);
	}
	$sortie=fopen($fichier, 'a');
	fputs($sortie, $message);
	fclose($sortie);
}

function litFichierJson($fichier) //lecture d'un fichier JSON
{
	if(file_exists($fichier))
	{
		$entree=fopen($fichier, 'r');
		$jsonstring=fread($entree, filesize($fichier));
		fclose($entree);
		$data=json_decode($jsonstring, true);
		return $data;
	}
	else
	{
		return 0;
	}
}

/*Fonctions générales*/

function lectureIdTableauNoeud($tableau, $cle, $valeur)
{
	$i=0;
	$length=sizeof($tableau);
	$retour=NULL;
	while($i<$length)
	{
		if(0==strcmp($tableau[$i][$cle], $valeur))//si on a trouvé la bonne valeur
		{
			$retour=$i;
			break;
		}	
		$i++;
	}
	return $retour;
}



function lectureIdTableauLien($tableau, $debut, $fin)
{
	$i=0;
	$length=sizeof($tableau);
	$retour=NULL;
	while($i<$length)
	{
		if((0==strcmp($tableau[$i]["from"], $debut))&&(0==strcmp($tableau[$i]["to"], $fin)))//si on a trouvé la bonne valeur
		{
			$retour=$i;
			break;
		}	
		$i++;
	}
	return $retour;
}

function lectureValeurTableau($tableau, $valeur, $champRecherche, $champRetour)
{
	$i=0;
	$length=sizeof($tableau);
	$retour=NULL;
	while($i<$length)
	{
		if($tableau[$i][$champRecherche]==$valeur)//si on a trouvé la bonne valeur
		{
			$retour=$tableau[$i][$champRetour];
			break;
		}	
		$i++;
	}
	return $retour;
}

function calculeMediane($tableau)
{
	sort($tableau);
	$milieu=floor(sizeof($tableau)/2);
	return $tableau[$milieu];
}
function ajouteLien($tableauLiens, $idLien, $debut, $fin)
{
	if(is_null($idLien))// si le lien n'existe pas encore
	{
		$lien=array();
		$lien["from"]=$debut;
		$lien["to"]=$fin;
		$lien["text"]=1;
		array_push($tableauLiens,$lien);
	}
	else //le lien existe déjà
	{
		$tableauLiens[$idLien]["text"]++;
	}
	return($tableauLiens);
}


function progress_bar($done, $total, $info="", $width=50) //https://gist.github.com/mayconbordin/2860547
{
	$perc = round(($done * 100) / $total);
	$bar = round(($width * $perc) / 100);
	return sprintf("%s%%[%s>%s]%s\r", $perc, str_repeat("=", $bar), str_repeat(" ", $width-$bar), $info);
}
/*Webservices de Moodle*/

function moodleLectureStructureLecon($idLecon, $url, $format) //lecture de la structure d'une leçon
{
	$fonction="&wsfunction=mod_lesson_get_pages";
	$arguments='&lessonid=' . $idLecon;
	$structureLecon=array();
	$curl=curl_init();
	$opts = [
		CURLOPT_URL => $url.$fonction.$arguments.$format,
		CURLOPT_RETURNTRANSFER => true
	];
	curl_setopt_array($curl, $opts);
	$structureLecon = json_decode(curl_exec($curl), true);//extraction des données de la leçon
	curl_close($curl);
	if(array_key_exists("exception",$structureLecon))
	{
		var_dump($structureLecon);
		$structureLecon=NULL;
	}
	return $structureLecon;
}

function moodleLectureListeTentativesLecon($idLecon, $url, $format) // lecture de la liste des utilisateurs et de leurs tentatives
{
	$fonction="&wsfunction=mod_lesson_get_attempts_overview";
	$arguments='&lessonid=' . $idLecon;
	$tentativesLecon=array();
	$curl=curl_init();
	$opts = [
		CURLOPT_URL => $url.$fonction.$arguments.$format,
		CURLOPT_RETURNTRANSFER => true
	];
	curl_setopt_array($curl, $opts);
	$tentativesLecon = json_decode(curl_exec($curl), true);//extraction des données de la leçon
	curl_close($curl);
	if(array_key_exists("exception",$tentativesLecon))
	{
		var_dump($tentativesLecon);
		$tentativesLecon=NULL;
	}
	return $tentativesLecon;
}

function moodleLectureTentativeLecon($idLecon, $idUser, $idTentative, $url, $format) // lecture de la tentative de la leçon
{
	$fonction="&wsfunction=mod_lesson_get_user_attempt";
	$arguments='&lessonid=' . $idLecon . '&userid=' . $idUser . "&lessonattempt=" . $idTentative;
	$tentativeLecon=array();
	$curl=curl_init();
	$opts = [
		CURLOPT_URL => $url.$fonction.$arguments.$format,
		CURLOPT_RETURNTRANSFER => true
	];
	curl_setopt_array($curl, $opts);
	$tentativeLecon = json_decode(curl_exec($curl), true);//extraction des données de la leçon
	curl_close($curl);
	if(array_key_exists("exception",$tentativeLecon))
	{
		var_dump($tentativeLecon);
		$tentativeLecon=NULL;
	}
	return $tentativeLecon;
}

function moodleLectureTentativeLeconPageContenu($idLecon, $idUser, $idTentative, $url, $format) // lecture de la tentative de la leçon
{
	$fonction="&wsfunction=mod_lesson_get_content_pages_viewed";
	$arguments='&lessonid=' . $idLecon . '&userid=' . $idUser . "&lessonattempt=" . $idTentative;
	$tentativeLecon=array();
	$curl=curl_init();
	$opts = [
		CURLOPT_URL => $url.$fonction.$arguments.$format,
		CURLOPT_RETURNTRANSFER => true
	];
	curl_setopt_array($curl, $opts);
	$tentativeLecon = json_decode(curl_exec($curl), true);//extraction des données de la leçon
	curl_close($curl);
	if(array_key_exists("exception",$tentativeLecon))
	{
		var_dump($tentativeLecon);
		$tentativeLecon=NULL;
	}
	return $tentativeLecon;
}

function moodleLectureTentativeLeconQuestions($idLecon, $idUser, $idTentative, $url, $format) // lecture de la tentative de la leçon
{
	$fonction="&wsfunction=mod_lesson_get_questions_attempts";
	$arguments='&lessonid=' . $idLecon . '&userid=' . $idUser . "&attempt=" . $idTentative;
	$questionLecon=array();
	$curl=curl_init();
	$opts = [
		CURLOPT_URL => $url.$fonction.$arguments.$format,
		CURLOPT_RETURNTRANSFER => true
	];
	curl_setopt_array($curl, $opts);
	$questionLecon = json_decode(curl_exec($curl), true);//extraction des données de la leçon
	curl_close($curl);
	if(array_key_exists("exception",$questionLecon))
	{
		var_dump($questionLecon);
		$questionLecon=NULL;
	}
	return $questionLecon;
}

function moodleLectureLeconDuree($idLecon, $idUser, $url, $format) // lecture des infos de durée de la leçon
{
	$fonction="&wsfunction=mod_lesson_get_user_timers";
	$arguments='&lessonid=' . $idLecon . '&userid=' . $idUser;
	$dureeLecon=array();
	$curl=curl_init();
	$opts = [
		CURLOPT_URL => $url.$fonction.$arguments.$format,
		CURLOPT_RETURNTRANSFER => true
	];
	curl_setopt_array($curl, $opts);
	$dureeLecon = json_decode(curl_exec($curl), true);//extraction des données de la leçon
	curl_close($curl);
	if(array_key_exists("exception",$questionLecon))
	{
		var_dump($dureeLecon);
		$dureeLecon=NULL;
	}
	return $dureeLecon;
}
?>

