# Env de dev

Vous pouvez initialiser un env de développement avec l'arborescence suivante :

```
.
├── data // Dossier contenant la base de données
├── docker-compose.yml
├── mod-otopo // Repo git avec le code du plugin
├── moodle // Repo git de moodle
├── moodle_data // Dossier contenant les data moodle
└── .npm // Dossier permettant d'installer les dépendances JS de dev
```

Attention à modifier l'uid de l'utilisateur dev dans le Dockerfile du projet si vous utilisez un uid sur votre poste différent de 1000.

## docker-compose.yml

Voici un exemple de fichier docker compose pour l'arborescence proposée :
```
version: '3'
services:
  moodle:
    build: mod-otopo/
    user: "1000:1000"
    environment:
      DB_HOST: 'mariadb'
      DB_USER: 'moodle'
      DB_PASS: 'moodle'
      DB_NAME: 'moodle'
      WWW_ROOT: 'http://localhost:8080'
      DATA_ROOT: '/var/www/moodledata/'
      DEV: 'true'
    ports:
      - 8080:8080
    volumes:
      - ./moodle/:/var/www/html/
      - ./mod-otopo/:/var/www/html/mod/otopo/
      - ./mod-otopo/config-moodle-docker.php:/var/www/html/config.php
      - ./moodle_data/:/var/www/moodledata/
      - ./.npm/:/.npm/
  mariadb:
    image: mariadb
    user: "1000:1000"
    environment:
      MYSQL_ROOT_PASSWORD: 'pass'
      MYSQL_USER: 'moodle'
      MYSQL_PASSWORD: 'moodle'
      MYSQL_DATABASE: 'moodle'
    ports:
      - 3306:3306
    volumes:
      - ./data/:/var/lib/mysql/
```

## Initialiser le dossier moodle

```
git clone https://github.com/moodle/moodle.git
cd moodle
git checkout v3.9.13
Versions supportées : de la 3.9.13 jusqu'a la 4.1.0
```

## Installation

Lancer le docker compose :

```
docker-compose up -d
```

Lancer le watcher JS afin d'avoir un rechargement des sources Javascript lors de leur modification.

```
docker-compose exec moodle npm install # à lancer la première fois
docker-compose exec moodle ./node_modules/grunt-cli/bin/grunt watch
```

Puis se rendre sur l'URL [http://localhost:8080](http://localhost:8080) et suivre les instructions d'instalation de moodle
