/**
 * Javascript controller for the "User summary" panel at the top of the page.
 *
 * @module     mod_assign/grading_review_panel
 * @package    mod_assign
 * @class      UserInfo
 * @copyright  2016 Damyon Wiese <damyon@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @since      3.1
 */
define("mod_otopo/grading_review_panel",["jquery","mod_assign/grading_events","core/notification","core/templates","core/str","core/chartjs"],(function($,GradingEvents,notification,templates,str,Chart){var GradingReviewPanel=function(selector){this._regionSelector=selector,this._region=$(selector),this.registerEventListeners(),$(document).on("participant-loaded",this._refreshReviewPanel.bind(this)),str.get_strings([{key:"autoeval_degree",component:"otopo"}]).done((function(strs){this._degreeStr=strs[0]})).fail(notification.exception),this._visual=this._region.data("otopovisual"),this._star=this._region.data("star"),this._starContainer=this._region.data("star-container"),this._help=this._region.data("help")};return GradingReviewPanel.prototype._regionSelector=null,GradingReviewPanel.prototype._region=null,GradingReviewPanel.prototype._visual="radar",GradingReviewPanel.prototype._degreeStr="",GradingReviewPanel.prototype._star="",GradingReviewPanel.prototype._starContainer="",GradingReviewPanel.prototype._help="",GradingReviewPanel.prototype._refreshReviewPanel=function(event,context){context.session.id?(context.star=this._star,context.help=this._help,context.star_container=this._starContainer,context.items.forEach((function(item){item.otopo_degree_description&&(item.otopo_degree_description=item.otopo_degree_description.replace(/\n/g,"<br />"))})),context.session_chart.label||(context.session_chart=null),templates.render("mod_otopo/grading_review",context).done(function(html,js){this._region.fadeOut("fast",function(){var options;if(templates.replaceNodeContents(this._region,html,js),"radar"==this._visual)options={scale:{ticks:{min:0,max:context.max,stepSize:1}}};else{var yScale={ticks:{min:0,max:context.max,stepSize:1,callbacks:function(value){return 0===value?"":this._degreeStr+" "+value}}},legend={display:!1};context.moodlePre4?(options={scales:{yAxes:[yScale]}}).legend=legend:((options={scales:{y:yScale}}).plugins={},options.plugins.legend=legend)}context.moodlePre4?options.tooltips={displayColors:!1,callbacks:{title:function(tooltipItems,chart){return chart.fullLabels[tooltipItems[0].index]},label:function(tooltipItem,data){var label=data.datasets[tooltipItem.datasetIndex].data[tooltipItem.index]||"0";return label+=data.datasets[tooltipItem.datasetIndex].labels[tooltipItem.index]?" - "+data.datasets[tooltipItem.datasetIndex].labels[tooltipItem.index]:"",label}}}:(options.plugins||(options.plugins={}),options.plugins.tooltip={displayColors:!1,callbacks:{title:function(context){if(context.length>0&&context[0].label)return context[0].label},label:function(context){if(context){var label=context.formattedValue||"0";return label+=context.dataset.labels[context.dataIndex]?" - "+context.dataset.labels[context.dataIndex]:"",label}}}});var sessionChartElement=document.getElementById("sessionChart");if(sessionChartElement&&context.session_chart){var config={type:this._visual,data:context.session_chart,options:options};new Chart(sessionChartElement,config)}this._region.fadeIn("fast")}.bind(this))}.bind(this)).fail(notification.exception)):this._region.html("")},GradingReviewPanel.prototype.getTogglePanelButton=function(){return this.getPanelElement().find('[data-region="review-panel-toggle"]')},GradingReviewPanel.prototype.getPanelElement=function(){return $('[data-region="review-panel"]')},GradingReviewPanel.prototype.getPanelContentElement=function(){return $('[data-region="review-panel-content"]')},GradingReviewPanel.prototype.togglePanel=function(){this.getPanelElement().hasClass("collapsed")?$(document).trigger(GradingEvents.EXPAND_REVIEW_PANEL):$(document).trigger(GradingEvents.COLLAPSE_REVIEW_PANEL)},GradingReviewPanel.prototype.collapsePanel=function(){this.getPanelElement().addClass("collapsed").removeClass("grade-panel-collapsed"),this.getPanelContentElement().attr("aria-hidden",!0)},GradingReviewPanel.prototype.expandPanel=function(){this.getPanelElement().removeClass("collapsed"),this.getPanelContentElement().removeAttr("aria-hidden")},GradingReviewPanel.prototype.registerEventListeners=function(){var toggleReviewPanelButton=this.getTogglePanelButton();toggleReviewPanelButton.click(function(e){this.togglePanel(),e.preventDefault()}.bind(this)),toggleReviewPanelButton.keydown(function(e){e.metaKey||e.shiftKey||e.altKey||e.ctrlKey||13!==e.keyCode&&32!==e.keyCode||(this.togglePanel(),e.preventDefault())}.bind(this));var docElement=$(document);docElement.on(GradingEvents.COLLAPSE_REVIEW_PANEL,function(){this.collapsePanel()}.bind(this)),docElement.on(GradingEvents.COLLAPSE_GRADE_PANEL,function(){this.expandPanel(),this.getPanelElement().addClass("grade-panel-collapsed")}.bind(this)),docElement.on(GradingEvents.EXPAND_REVIEW_PANEL,function(){this.expandPanel()}.bind(this)),docElement.on(GradingEvents.EXPAND_GRADE_PANEL,function(){this.getPanelElement().removeClass("grade-panel-collapsed")}.bind(this))},GradingReviewPanel}));

//# sourceMappingURL=grading_review_panel.min.js.map