import {exception as displayException} from 'core/notification';
import Templates from 'core/templates';
import Ajax from 'core/ajax';
import Chart from 'core/chartjs';

export const init = (otopo, degreeStr) => {
    async function loadAjaxEvolution(otopo, visual, item) {
        var promises = Ajax.call([
            { methodname: 'mod_otopo_get_my_evolution', args: {
                otopo: otopo,
                visual: visual,
                item: item
            }}
        ]);
        const chart = await promises[0];

        return chart;
    }

    function reloadPage(otopo) {
        const visual = document.getElementById('id_visual').value;
        const item = parseInt(document.getElementById('id_item').value);

        loadAjaxEvolution(parseInt(otopo), visual, item).then((data) => {
            data.has_charts = data.charts.length > 0;
            data.current_chart = data.current_chart.id ? data.current_chart : null;
            data.chart_item = data.chart_item.id ? data.chart_item : null;
            data.star = document.getElementById('evolution').dataset.star;

            Templates.renderForPromise('mod_otopo/evol', data)

                .then(({html, js}) => {
                    Templates.replaceNodeContents('#evolution', html, js);
                    let options;
                    if (visual == 'radar') {
                        options = {
                            scale: {
                                ticks: {
                                    min: 0,
                                    max: data.max,
                                    stepSize: 1
                                }
                            }
                        };
                    } else {
                        const yScale = {
                            ticks: {
                                min: 0,
                                max: data.max,
                                stepSize: 1,
                                callbacks: function (value) {
                                    if (value === 0) {
                                        return "";
                                    }
                                    return degreeStr + " " + value;
                                }
                            }
                        };
                        const legend = {display: false};
                        if (data.moodlePre4) {
                            options = {
                                scales: {
                                    yAxes: [yScale]
                                }
                            };
                            options.legend = legend;
                        } else {
                            options = {
                                scales: {
                                    y: yScale
                                }
                            };
                            options.plugins = {};
                            options.plugins.legend = legend;
                        }
                    }
                    if (data.moodlePre4) {
                        options.tooltips = {
                            displayColors: false,
                            callbacks: {
                                title: function (tooltipItems, chart) {
                                    return chart.fullLabels[tooltipItems[0].index];
                                },
                                label: function (tooltipItem, data) {
                                    let label = data.datasets[tooltipItem.datasetIndex].data[tooltipItem.index] || '0';
                                    label += data.datasets[tooltipItem.datasetIndex].labels[tooltipItem.index] ?
                                        (' - ' + data.datasets[tooltipItem.datasetIndex].labels[tooltipItem.index]) : '';
                                    return label;
                                }
                            }
                        };
                    } else {
                        if (!options.plugins) {
                            options.plugins = {};
                        }
                        options.plugins.tooltip = {
                            displayColors: false,
                            callbacks: {
                                title: function (context) {
                                    if (context.length > 0 && context[0].label) {
                                        return context[0].label;
                                    }
                                },
                                label: function (context) {
                                    if (context) {
                                        let label = context.formattedValue || '0';
                                        label += context.dataset.labels[context.dataIndex] ?
                                            (' - ' + context.dataset.labels[context.dataIndex]) : '';
                                        return label;
                                    }
                                }
                            }
                        };
                    }
                    const currentChartElement = document.getElementById('currentChart');
                    if (currentChartElement && data.current_chart) {
                        const config = {
                            type: visual,
                            data: data.current_chart,
                            options: options
                        };
                        new Chart(
                            currentChartElement,
                            config
                        );
                    }

                    data.charts.forEach(function(chart) {
                        const chartElement = document.getElementById('chart' + chart.id);
                        if(chartElement) {
                            const config = {
                                type: visual,
                                data: chart,
                                options: options
                            };
                            new Chart(
                                chartElement,
                                config
                            );
                        }
                    });

                    const chartItemElement = document.getElementById('chartItem');
                    if(chartItemElement && data.chart_item) {
                        if (data.moodlePre4) {
                            options.tooltips = {
                                displayColors: false,
                                callbacks: {
                                    label: function (tooltipItem, data) {
                                        var label = data.label || '';
                                        if (label) {
                                            label += ': ';
                                        }
                                        label += data.datasets[tooltipItem.datasetIndex].data[tooltipItem.index] || '0';
                                        label += data.fullLabels[tooltipItem.index] ?
                                            (' - ' + data.fullLabels[tooltipItem.index]) : '';
                                        return label;
                                    }
                                }
                            };
                        } else {
                            if (!options.plugins) {
                                options.plugins = {};
                            }
                            options.plugins.tooltip = {
                                displayColors: false,
                                callbacks: {
                                    title: function (context) {
                                        if (context.length > 0 && context[0].label) {
                                            return context[0].label;
                                        }
                                    },
                                    label: function (context) {
                                        if (context) {
                                            let label = context.formattedValue || '0';
                                            label += ': ';
                                            label += context.dataset.label ? context.dataset.label : '';
                                            return label;
                                        }
                                    }
                                }
                            };
                        }
                        const config = {
                            type: visual,
                            data: data.chart_item,
                            options: options
                        };
                        new Chart(
                            chartItemElement,
                            config
                        );
                    }

                })
                .catch(ex => displayException(ex));

        });
    }

    document.getElementById('id_visual').onchange = function() {
        reloadPage(otopo);
    };
    document.getElementById('id_item').onchange = function() {
        reloadPage(otopo);
    };

    reloadPage(otopo);

    var lastWidth = 0;
    var lastHeight = 0;
    window.onbeforeprint = () => {
        for (var id in Chart.instances) {
            lastHeight = Chart.instances[id].canvas.parentNode.style.height;
            lastWidth = Chart.instances[id].canvas.parentNode.style.width;
            Chart.instances[id].canvas.parentNode.style.height = '850px';
            Chart.instances[id].canvas.parentNode.style.width = '850px';
            Chart.instances[id].resize();
        }
    };
    window.addEventListener('afterprint', () => {
        for (var id in Chart.instances) {
            Chart.instances[id].canvas.parentNode.style.height = lastHeight;
            Chart.instances[id].canvas.parentNode.style.width = lastWidth;
            Chart.instances[id].resize();
        }
    });
};
