import Item from 'mod_otopo/items/components/item';
import store from 'mod_otopo/items/store';

var Items = {
    components: {
        'Item': Item,
    },
    props: {
        otopo: {
            type: Number
        },
    },
    data: function () {
        return {
            items: this.$root.$data.state.items,
            strings: this.$root.$data.strings,
            hasOtopo: this.$root.$data.hasOtopo,
        };
    },
    methods: {
        addItem() {
            if(!this.hasOtopo) {
                store.addItem({'id': null, 'name': '', color: '#000000', 'degrees': [],
                               'ord': this.items.length > 0 ? this.items[this.items.length - 1].ord + 1 : 0});
            }
        },
    },
    template: `
<div class="items">
    <Item
        v-for="(item, index) in items"
        :key="item.id ? item.id : 'new' + index"
        :item="item"
        :index="index"
        :otopo="otopo"
    />
    <button
        v-on:click="addItem"
        class="btn btn-primary mt-2"
        :disabled="hasOtopo"
    >
        {{ strings.add_item }}
    </button>
</div>
`,
};

export default Items;
