<?php

/**
 * Define all the backup steps that will be used by the backup_otopo_activity_task
 */

/**
 * Define the complete otopo structure for backup, with file and id annotations
 */     
class backup_otopo_activity_structure_step extends backup_activity_structure_step {

    protected function define_structure() {

        // To know if we are including userinfo
        $userinfo = $this->get_setting_value('userinfo');

        // Define each element separated
        $otopo = new backup_nested_element('otopo', array('id'), array(
            'name', 'intro', 'introformat', 'timemodified',
            'showteachercomments', 'session', 'sessions', 'limit_sessions',
            'grade', 'gradeonlyforteacher',
            'allowsubmissionfromdate', 'allowsubmissiontodate',
            'sessionvisual', 'cohortvisual', 'completionsubmit'));

        $sessions = new backup_nested_element('nested_sessions');

        $session = new backup_nested_element('session', array('id'), array(
            'name', 'color', 'allowsubmissionfromdate', 'allowsubmissiontodate'));

        $items = new backup_nested_element('items');

        $item = new backup_nested_element('item', array('id'), array(
            'name', 'color', 'ord'));

        $degrees = new backup_nested_element('degrees');

        $degree = new backup_nested_element('degree', array('id'), array(
            'name', 'description', 'grade', 'ord'));


        $user_otopos = new backup_nested_element('user_otopos');

        $user_otopo = new backup_nested_element('user_otopo', array('id'), array(
            'user', 'session', 'degree', 'justification', 'lastmodificationdate', 'teacher_comment'));

        $user_valid_sessions = new backup_nested_element('user_valid_sessions');

        $user_valid_session = new backup_nested_element('user_valid_session', array('id'), array(
            'user', 'session'));

        $graders = new backup_nested_element('graders');

        $grader = new backup_nested_element('grader', array('id'), array(
            'user', 'session', 'comment', 'grade'));


        // Build the tree
        $otopo->add_child($sessions);
        $sessions->add_child($session);

        $otopo->add_child($items);
        $items->add_child($item);

        $item->add_child($degrees);
        $degrees->add_child($degree);

        $item->add_child($user_otopos);
        $user_otopos->add_child($user_otopo);

        $otopo->add_child($user_valid_sessions);
        $user_valid_sessions->add_child($user_valid_session);

        $otopo->add_child($graders);
        $graders->add_child($grader);


        // Define sources
        $otopo->set_source_table('otopo', array('id' => backup::VAR_ACTIVITYID));
        $session->set_source_table('otopo_session', array('otopo' => backup::VAR_ACTIVITYID));
        $item->set_source_table('otopo_item', array('otopo' => backup::VAR_ACTIVITYID));
        $degree->set_source_table('otopo_item_degree', array('item' => backup::VAR_PARENTID));

        // All the rest of elements only happen if we are including user info
        if ($userinfo) {
            $user_otopo->set_source_table('otopo_user_otopo', array('item' => backup::VAR_PARENTID));
            $user_valid_session->set_source_table('otopo_user_valid_session', array('otopo' => backup::VAR_ACTIVITYID));
            $grader->set_source_table('otopo_grader', array('otopo' => backup::VAR_ACTIVITYID));
        }


        // Define id annotations
        $user_otopo->annotate_ids('user', 'user');
        $user_valid_session->annotate_ids('user', 'user');
        $grader->annotate_ids('user', 'user');

        $otopo->annotate_files('mod_otopo', 'intro', null, $contextid = null);

        // Return the root element (otopo), wrapped into standard activity structure
        return $this->prepare_activity_structure($otopo);

    }
}
