<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Form to add/remove and edit sessions
 *
 * @package     mod_otopo
 * @copyright   2022 Kosmos <moodle@kosmos.fr>
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
require_once("$CFG->libdir/formslib.php");

class sessions_form extends moodleform {
    //Add elements to form
    public function definition() {
        global $CFG, $DB, $PAGE, $OUTPUT;

        $mform = $this->_form;

        $mform->addElement('hidden', 'o', $this->_customdata['o']);
        $mform->setType('o', PARAM_INT);
        $mform->addElement('hidden', 'action', 'edit');
        $mform->setType('action', PARAM_TEXT);
        $mform->addElement('hidden', 'object', 'sessions');
        $mform->setType('object', PARAM_TEXT);

        $defaults_date = array(
            'optional' => false,
            'startyear' => 2020,
            'stopyear'  => 2040,
            'timezone'  => 99,
            'step'      => 5
        );

        $repeatarray = array();
        $repeatarray[] = $mform->createElement('text', 'name', get_string('session_name', 'otopo'), array('size'=>'64'));
        $colorEl = $mform->createElement('text', 'color', get_string('session_color', 'otopo'), array('class' => 'input-colorpicker'));
        $repeatarray[] = $colorEl;
        $repeatarray[] = $mform->createElement('hidden', 'id', 0);
        $repeatarray[] = $mform->createElement('date_time_selector', 'allowsubmissionfromdate', get_string('session_allowsubmissionfromdate', 'otopo'), $defaults_date);
        $repeatarray[] = $mform->createElement('date_time_selector', 'allowsubmissiontodate', get_string('session_allowsubmissiontodate', 'otopo'), $defaults_date);
        $repeatarray[] = $mform->createElement('button', 'delete', get_string("session_delete", 'otopo'), array('class' => 'deletesession'));

        $repeatno = $this->_customdata['count_sessions'];
        if($repeatno == 0) {
            $repeatno = $this->_customdata['sessions'];
        }

        $repeateloptions = array();

        $mform->setType('name', PARAM_TEXT);
        $mform->setType('color', PARAM_TEXT);
        $mform->setType('id', PARAM_INT);

        $repeateloptions['allowsubmissionfromdate']['rule'] = 'required';
        $repeateloptions['allowsubmissiontodate']['rule'] = 'required';

        $this->repeat_elements($repeatarray, $repeatno,
                               $repeateloptions, 'option_repeats', 'option_add_fields', 1, get_string('session_add', 'otopo'), true);

        $this->add_action_buttons();
    }

    function set_data($default_values) {
        if (is_object($default_values)) {
            $default_values = (array)$default_values;
        }

        if(!$default_values) {
            $default_values = [];
        }
        if(!array_key_exists('name', $default_values)) {
            $default_values['name'] = [];
        }
        if(!array_key_exists('color', $default_values)) {
            $default_values['color'] = [];
        }
        for($i = 0; $i < $this->_form->_constantValues['option_repeats']; $i++) {
            if(!array_key_exists($i, $default_values['name'])) {
                $default_values['name'][$i] = "Session " . strval($i+1);
            }
            if(!array_key_exists($i, $default_values['color'])) {
                $default_values['color'][$i] = '#000000';
            }
        }
        parent::set_data($default_values);
    }


    //Custom validation should be added here
    function validation($data, $files) {
        $errors = array();
        for($i = 0; $i<$data['option_repeats']; $i++) {
            if($data['allowsubmissionfromdate'][$i] && $data['allowsubmissiontodate'][$i]
               && $data['allowsubmissionfromdate'][$i] >= $data['allowsubmissiontodate'][$i])
                $errors["allowsubmissiontodate[{$i}]"] = get_string('allowsubmissiondateerror', 'otopo');
        }
        return $errors;
    }
}
?>
