/**
 * Javascript controller for the "User summary" panel at the top of the page.
 *
 * @module     mod_assign/grading_navigation_user_info
 * @package    mod_assign
 * @class      UserInfo
 * @copyright  2016 Damyon Wiese <damyon@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @since      3.1
 */
define("mod_otopo/grading_navigation_user_info",["jquery","core/notification","core/ajax","core/templates","core/str"],(function($,notification,ajax,templates,str){var UserInfo=function(selector,sessionSelector){this._regionSelector=selector,this._region=$(selector),this._sessionRegionSelector=sessionSelector,this._sessionRegion=$(sessionSelector),$(document).on("user-changed",this._refreshUserInfoAndLoadSessions.bind(this)),$(document).on("session-changed",this._refreshUserInfo.bind(this)),str.get_strings([{key:"last_modification",component:"otopo"}]).done(function(strs){this._lastModificationStr=strs[0]}.bind(this)).fail(notification.exception)};return UserInfo.prototype._regionSelector=null,UserInfo.prototype._sessionRegionSelector=null,UserInfo.prototype._region=null,UserInfo.prototype._sessionRegion=null,UserInfo.prototype._lastUserId=0,UserInfo.prototype._lastSessionId=0,UserInfo.prototype._lastModificationStr="",UserInfo.prototype._getOtopoId=function(){return this._region.attr("data-otopoid")},UserInfo.prototype._refreshUserInfoAndLoadSessions=function(event,userid){var session=this._lastSessionId>0?this._lastSessionId:$('[data-region="grading-navigation-panel"]').data("first-session");this._refreshUserInfo(event,userid,session,!0)},UserInfo.prototype._refreshUserInfo=function(event,userid,session){var loadSessions=arguments.length>3&&void 0!==arguments[3]&&arguments[3],force=arguments.length>4&&void 0!==arguments[4]&&arguments[4],promise=$.Deferred();this._region.attr("data-userid",userid),this._lastUserId==userid&&session&&this._lastSessionId==session&&!force||(this._lastUserId=userid,this._lastSessionId=session,templates.render("mod_assign/loading",{}).done(function(html,js){if(this._region.fadeOut("fast",function(){templates.replaceNodeContents(this._region,html,js),this._region.fadeIn("fast")}.bind(this)),userid<0)templates.render("mod_assign/grading_navigation_no_users",{}).done(function(html,js){userid==this._lastUserId&&this._region.fadeOut("fast",function(){templates.replaceNodeContents(this._region,html,js),this._region.fadeIn("fast")}.bind(this))}.bind(this)).fail(notification.exception);else{var otopoId=this._getOtopoId();ajax.call([{methodname:"mod_otopo_get_participant",args:{userid:userid,otopo:otopoId,session:session}}])[0].done(function(participant){participant.hasOwnProperty("id")?promise.resolve(participant):promise.reject("No users")}.bind(this)).fail(notification.exception),promise.done(function(context){$(document).trigger("participant-loaded",context),$("#grading-actions-buttons button").prop("disabled",!context.session.validated);var identityfields=$("[data-showuseridentity]").data("showuseridentity").split(","),identity=[];if(context.courseid=$('[data-region="grading-navigation-panel"]').attr("data-courseid"),context.user&&($.each(identityfields,(function(i,k){void 0!==context.user[k]&&""!==context.user[k]&&(context.hasidentity=!0,identity.push(context.user[k]))})),context.identity=identity.join(", "),context.user.profileimageurl&&(context.profileimageurl=context.user.profileimageurl)),templates.render("mod_otopo/grading_navigation_user_summary",context).done(function(html,js){userid==this._lastUserId&&this._region.fadeOut("fast",function(){templates.replaceNodeContents(this._region,html,js),this._region.fadeIn("fast")}.bind(this))}.bind(this)).fail(notification.exception),loadSessions){var first_session=$('[data-region="grading-navigation-panel"]').data("first-session");templates.render("mod_otopo/grading_navigation_session_selector",context).done(function(html,js){userid==this._lastUserId&&this._sessionRegion.fadeOut("fast",function(){templates.replaceNodeContents(this._sessionRegion,html,js),this._setLastModification(context.session.lastmodification),this._sessionRegion.fadeIn("fast"),this._sessionRegion.find('[data-action="change-session"]').on("change",this._handleChangeSession.bind(this))}.bind(this))}.bind(this)).fail(notification.exception),$(document).trigger("session-changed",[this._lastUserId,first_session])}else this._setLastModification(context.session.lastmodification)}.bind(this)).fail(function(){templates.render("mod_assign/grading_navigation_no_users",{}).done(function(html,js){this._region.fadeOut("fast",function(){templates.replaceNodeContents(this._region,html,js),this._region.fadeIn("fast")}.bind(this))}.bind(this)).fail(notification.exception)}.bind(this))}}.bind(this)).fail(notification.exception))},UserInfo.prototype._setLastModification=function(lastmodification){lastmodification?this._sessionRegion.find("#otopo_lastmodification").html(this._lastModificationStr+": "+lastmodification):this._sessionRegion.find("#otopo_lastmodification").html("")},UserInfo.prototype._handleChangeSession=function(){var select=this._sessionRegion.find("[data-action=change-session]"),session=parseInt(select.val(),10),url=new URL(window.location);url.searchParams.set("session",session),window.history.replaceState({},"",url),$(document).trigger("session-changed",[this._lastUserId,session])},UserInfo}));

//# sourceMappingURL=grading_navigation_user_info.min.js.map