/**
 * Javascript controller for the "Grading" panel at the right of the page.
 *
 * @module     mod_assign/grading_panel
 * @package    mod_assign
 * @class      GradingPanel
 * @copyright  2016 Damyon Wiese <damyon@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @since      3.1
 */
define("mod_otopo/grading_panel",["jquery","core/yui","core/notification","core/templates","core/fragment","core/ajax","core/str","mod_assign/grading_form_change_checker","mod_assign/grading_events","core/event"],(function($,Y,notification,templates,fragment,ajax,str,checker,GradingEvents,Event){var GradingPanel=function(selector){this._regionSelector=selector,this._region=$(selector),this._userCache=[],this.registerEventListeners()};return GradingPanel.prototype._regionSelector=null,GradingPanel.prototype._lastUserId=0,GradingPanel.prototype._lastSession=0,GradingPanel.prototype._region=null,GradingPanel.prototype.nextUserId=null,GradingPanel.prototype.nextUser=!1,GradingPanel.prototype._niceReplaceNodeContents=function(node,html,js){var promise=$.Deferred();return node.fadeOut("fast",(function(){templates.replaceNodeContents(node,html,js),node.fadeIn("fast",(function(){promise.resolve()}))})),promise.promise()},GradingPanel.prototype._saveFormState=function(){var checked=$('[data-region="grading-actions-form"] [name="sendstudentnotifications"]').prop("checked");$('.gradeform [name="sendstudentnotifications"]').val(checked)},GradingPanel.prototype._submitForm=function(event,nextUserId,nextUser){var form=$(this._region.find("form.gradeform"));$('[data-region="overlay"]').show(),form.trigger("save-form-state"),Event.notifyFormSubmitAjax(form[0]);var data=form.serialize(),otopoid=this._region.attr("data-otopoid"),itemsComments=[];this._region.find(".grade-item textarea").each((function(){$(this).val()&&itemsComments.push({id:$(this).data("item"),value:$(this).val()})})),ajax.call([{methodname:"mod_otopo_submit_grading_form",args:{otopo:otopoid,userid:this._lastUserId,session:this._lastSession,jsonformdata:JSON.stringify(data),itemscomments:itemsComments},done:this._handleFormSubmissionResponse.bind(this,data,nextUserId,nextUser),fail:notification.exception}])},GradingPanel.prototype._handleFormSubmissionResponse=function(formdata,nextUserId,nextUser,response){void 0===nextUserId&&(nextUserId=this._lastUserId),response.length?$(document).trigger("reset",[this._lastUserId,this._lastSession,formdata]):(str.get_strings([{key:"changessaved",component:"core"},{key:"gradechangessaveddetail",component:"mod_assign"}]).done((function(strs){notification.alert(strs[0],strs[1])})).fail(notification.exception),Y.use("moodle-core-formchangechecker",(function(){M.core_formchangechecker.reset_form_dirty_state()})),nextUserId==this._lastUserId?$(document).trigger("reset",[nextUserId,this._lastSession]):nextUser?$(document).trigger("done-saving-show-next",!0):$(document).trigger("user-changed",nextUserId)),$('[data-region="overlay"]').hide()},GradingPanel.prototype._resetForm=function(e,userid,session,formdata){var event=$.Event("custom");void 0===userid&&(userid=this._lastUserId),this._lastUserId=0,void 0===session&&(session=this._lastSession),this._refreshGradingPanel(event,userid,session,formdata,(function(){$(document).trigger("session-changed",[userid,session,!1,!0])}))},GradingPanel.prototype._addPopoutButtons=function(selector){var region=$(selector);templates.render("mod_assign/popout_button",{}).done(function(html){region.find('[data-fieldtype="filemanager"],[data-fieldtype="editor"],[data-fieldtype="grading"]').closest(".fitem").addClass("has-popout").find("label").parent().append(html),region.on("click",'[data-region="popout-button"]',this._togglePopout.bind(this))}.bind(this)).fail(notification.exception)},GradingPanel.prototype._togglePopout=function(event){event.preventDefault();var container=$(event.target).closest(".fitem");container.hasClass("popout")?$(".popout").removeClass("popout"):($(".popout").removeClass("popout"),container.addClass("popout"),container.addClass("moodle-has-zindex"))},GradingPanel.prototype._refreshGradingPanel=function(event,userid,session,submissiondata){var callbackUserLoaded=arguments.length>4&&void 0!==arguments[4]?arguments[4]:null,contextid=this._region.attr("data-contextid");void 0===submissiondata&&(submissiondata=""),this._lastUserId==userid&&this._lastSession==session&&""===submissiondata||(this._lastUserId=userid,this._lastSession=session,$(document).trigger("start-loading-user"),window.M.util.js_pending("mod-assign-loading-user"),templates.render("mod_assign/loading",{}).done(function(html,js){this._niceReplaceNodeContents(this._region,html,js).done(function(){if(userid>0){this._region.show();var params={userid:userid,session:session,jsonformdata:JSON.stringify(submissiondata)};fragment.loadFragment("mod_otopo","gradingpanel",contextid,params).done(function(html,js){this._niceReplaceNodeContents(this._region,html,js).done(function(){checker.saveFormState('[data-region="grade-panel"] .gradeform'),$(document).on("editor-content-restored",(function(){checker.saveFormState('[data-region="grade-panel"] .gradeform')})),this._addPopoutButtons('[data-region="grade-panel"] .gradeform'),$(document).trigger("finish-loading-user"),null!==callbackUserLoaded&&"function"==typeof callbackUserLoaded&&callbackUserLoaded(),window.M.util.js_complete("mod-assign-loading-user")}.bind(this)).fail(notification.exception)}.bind(this)).fail(notification.exception),$('[data-region="review-panel"]').show()}else this._region.hide(),$('[data-region="review-panel"]').hide(),$(document).trigger("finish-loading-user"),window.M.util.js_complete("mod-assign-loading-user")}.bind(this))}.bind(this)).fail(notification.exception))},GradingPanel.prototype._getNextUser=function(event,data){this.nextUserId=data.nextUserId,this.nextUser=data.nextUser},GradingPanel.prototype._handleSaveAndShowNext=function(){this._submitForm(null,this.nextUserId,this.nextUser)},GradingPanel.prototype.getPanelElement=function(){return $('[data-region="grade-panel"]')},GradingPanel.prototype.collapsePanel=function(){this.getPanelElement().addClass("collapsed")},GradingPanel.prototype.expandPanel=function(){this.getPanelElement().removeClass("collapsed")},GradingPanel.prototype.registerEventListeners=function(){var docElement=$(document);$(this._region).on("submit","form",(function(e){e.preventDefault()})),docElement.on("next-user",this._getNextUser.bind(this)),docElement.on("session-changed",this._refreshGradingPanel.bind(this)),docElement.on("save-changes",this._submitForm.bind(this)),docElement.on("save-and-show-next",this._handleSaveAndShowNext.bind(this)),docElement.on("reset",this._resetForm.bind(this)),docElement.on("save-form-state",this._saveFormState.bind(this)),docElement.on(GradingEvents.COLLAPSE_GRADE_PANEL,function(){this.collapsePanel()}.bind(this)),docElement.on(GradingEvents.COLLAPSE_REVIEW_PANEL,function(){this.expandPanel()}.bind(this)),docElement.on(GradingEvents.EXPAND_GRADE_PANEL,function(){this.expandPanel()}.bind(this))},GradingPanel}));

//# sourceMappingURL=grading_panel.min.js.map