import Ajax from 'core/ajax';
import Items from 'mod_otopo/items/components/items';
import Vue from 'vue';
import store from 'mod_otopo/items/store';
import ajax from 'mod_otopo/items/ajax';

export const initGrid = (otopo, hasOtopo, cmid = 0) => {

    async function getStrings() { // eslint-disable-line no-unused-vars
        var strings = {};
        var promises = Ajax.call([
            { methodname: 'core_get_string', args: { component: 'otopo', stringid: 'item_add_item' } },
            { methodname: 'core_get_string', args: { component: 'otopo', stringid: 'item_delete_item' } },
            { methodname: 'core_get_string', args: { component: 'otopo', stringid: 'item_choose_item_color' } },
            { methodname: 'core_get_string', args: { component: 'otopo', stringid: 'item_item' } },
            { methodname: 'core_get_string', args: { component: 'otopo', stringid: 'item_degree' } },
            { methodname: 'core_get_string', args: { component: 'otopo', stringid: 'item_add_degree' } },
            { methodname: 'core_get_string', args: { component: 'otopo', stringid: 'item_delete_degree' } },
            { methodname: 'core_get_string', args: { component: 'otopo', stringid: 'item_degree_grade' } },
            { methodname: 'core_get_string', args: { component: 'otopo', stringid: 'item_duplicate_item' } },
            { methodname: 'core_get_string', args: { component: 'otopo', stringid: 'string_limit_255' } },
        ]);
        strings['add_item'] = await promises[0];
        strings['delete_item'] = await promises[1];
        strings['choose_item_color'] = await promises[2];
        strings['item'] = await promises[3];
        strings['degree'] = await promises[4];
        strings['add_degree'] = await promises[5];
        strings['delete_degree'] = await promises[6];
        strings['degree_grade'] = await promises[7];
        strings['duplicate_item'] = await promises[8];
        strings['string_limit_255'] = await promises[9];

        return strings;
    }

    async function initStore(otopo, cmid) {
        var items = await ajax.getItems(otopo, cmid);
        store.state.items = items;
    }

    initStore(otopo, cmid).then(() => {
        otopo = parseInt(otopo);
        getStrings().then((strings) => {
            var app = new Vue({  // eslint-disable-line no-unused-vars
                el: '#otopo-grid',
                components: {
                    'Items': Items,
                },
                template: '<Items :otopo="otopo"></Items>',
                data: {
                    otopo: otopo,
                    cmid: cmid,
                    hasOtopo: hasOtopo,
                    strings: strings,
                    state: store.state
                }
            });
        });
    });
};
