import Vue from 'vue';
import Items from 'mod_otopo/preview_sessions/components/items';
import ajax from 'mod_otopo/items/ajax';
import utils from 'mod_otopo/utils';

export const init = (otopo, showComments, starPng, starContainerPng, helpPng, plusPng, minusPng) => {
    var images = {
        'star': starPng,
        'starContainer': starContainerPng,
        'help': helpPng,
        'plus': plusPng,
        'minus': minusPng
    };


    ajax.getItems(otopo).then((items) => {
        utils.getAutoEvalStrings().then((strings) => {
            var app = new Vue({  // eslint-disable-line no-unused-vars
                el: '#preview-sessions',
                components: {
                    'Items': Items,
                },
                template: '<Items></Items>',
                data: {
                    showComments: showComments,
                    items: items,
                    strings: strings,
                    images: images
                }
            });
        });
    });
};
