import Ajax from 'core/ajax';

const utils = {
    debounce(func, timeout = 1000) {
        let timer;
        return (...args) => {
            clearTimeout(timer);
            timer = setTimeout(() => { func.apply(this, args); }, timeout);
        };
    },
    async getAutoEvalStrings() {
        var strings = {};
        var promises = Ajax.call([
            { methodname: 'core_get_string', args: { component: 'otopo', stringid: 'autoeval' } },
            { methodname: 'core_get_string', args: { component: 'otopo', stringid: 'autoeval_help' } },
            { methodname: 'core_get_string', args: { component: 'otopo', stringid: 'autoeval_your_justification' } },
            { methodname: 'core_get_string', args: { component: 'otopo', stringid: 'autoeval_no_teacher_comment' } },
            { methodname: 'core_get_string', args: { component: 'otopo', stringid: 'autoeval_modal_subtitle' } },
            { methodname: 'core_get_string', args: { component: 'otopo', stringid: 'autoeval_modal_content' } },
            { methodname: 'core_get_string', args: { component: 'otopo', stringid: 'autoeval_modal_content1' } },
            { methodname: 'core_get_string', args: { component: 'otopo', stringid: 'autoeval_modal_content2' } },
            { methodname: 'core_get_string', args: { component: 'otopo', stringid: 'autoeval_desc' } },
            { methodname: 'core_get_string', args: { component: 'otopo', stringid: 'autoeval_degree' } },
            { methodname: 'core_get_string', args: { component: 'otopo', stringid: 'autoeval_description' } }
        ]);
        strings['autoeval'] = await promises[0];
        strings['help'] = await promises[1];
        strings['your_justification'] = await promises[2];
        strings['no_teacher_comment'] = await promises[3];
        strings['modal_subtitle'] = await promises[4];
        strings['modal_content'] = await promises[5];
        strings['modal_content1'] = await promises[6];
        strings['modal_content2'] = await promises[7];
        strings['desc'] = await promises[8];
        strings['degree'] = await promises[9];
        strings['description'] = await promises[10];

        return strings;
    }
};

export default utils;
