<?php

require_once($CFG->dirroot . '/mod/otopo/backup/moodle2/backup_otopo_stepslib.php');

/**
 * choice backup task that provides all the settings and steps to perform one
 * complete backup of the activity
 */
class backup_otopo_activity_task extends backup_activity_task {

    /**
     * Define (add) particular settings this activity can have
     */
    protected function define_my_settings() {
        // No particular settings for this activity
    }

    /**
     * Define (add) particular steps this activity can have
     */
    protected function define_my_steps() {
        $this->add_step(new backup_otopo_activity_structure_step('otopo_structure', 'otopo.xml'));
    }

    /**
     * Code the transformations to perform in the activity in
     * order to get transportable (encoded) links
     */
    static public function encode_content_links($content) {
        global $CFG;

        $base = preg_quote($CFG->wwwroot,"/");

        // Link to the list of otopos
        $search="/(".$base."\/mod\/otopo\/index.php\?id\=)([0-9]+)/";
        $content= preg_replace($search, '$@OTOPOINDEX*$2@$', $content);

        // Link to choice view by moduleid
        $search="/(".$base."\/mod\/otopo\/view.php\?id\=)([0-9]+)/";
        $content= preg_replace($search, '$@OTOPOVIEWBYID*$2@$', $content);

        return $content;
    }
}
