<?php
namespace mod_otopo\table;

require_once(__DIR__.'/../../locallib.php');

defined('MOODLE_INTERNAL') || die();

use core_table\dynamic as dynamic_table;
use moodle_url;
use core_table\local\filter\filterset;

class participants extends \core_user\table\participants implements dynamic_table {
    private $cmid;
    private $otopo;
    private $action;
    private $object;
    private $can_grade;

    /**
     * Render the participants table.
     *
     * @param int $pagesize Size of page for paginated displayed table.
     * @param bool $useinitialsbar Whether to use the initials bar which will only be used if there is a fullname column defined.
     * @param string $downloadhelpbutton
     */
    public function out($pagesize, $useinitialsbar, $downloadhelpbutton = '') {
        global $CFG, $OUTPUT, $PAGE, $DB;

        // Define the headers and columns.
        $headers = [];
        $columns = [];

        $this->users_sessions_with_otopos = get_users_sessions_with_otopos($this->otopo);
        $this->graders = get_graders($this->otopo);
        $this->auto_grades = [];
        $items = get_items_sorted_from_otopo($this->otopo->id);
        //foreach($this->users_sessions_with_otopos as $userid => $otopos_sessions) {
        //    $user = (object)array('id' => $userid);
        //    $otopos = get_user_otopos($this->otopo, $user);
        //   $sessions = prepare_data($this->otopo, $items, $otopos, $user);
        //}
        $modulecontext = \context_module::instance($this->cmid);
        foreach(get_participants($this->otopo, $modulecontext) as $participant) {
            $otopos = get_user_otopos($this->otopo, $participant);
            $sessions = prepare_data($this->otopo, $items, $otopos, $participant);
            $i = 0;
            foreach($sessions as $session) {
                if(($i == count($sessions) - 1) && !session_is_valid($this->otopo->id, $participant, $session->id)) {
                    ++$i;
                    continue;
                }
                $this->auto_grades[$participant->id][$session->id] = $session->grade;
                ++$i;
            }
        }


        $headers[] = get_string('fullname');
        $columns[] = 'fullname';

        $headers[] = get_string('menu_sessions', 'otopo');
        $columns[] = 'sessions';

        $headers[] = get_string('grade', 'otopo');
        $columns[] = 'grades';

        $headers[] = get_string('sessions_comments', 'otopo');
        $columns[] = 'comments';

        $this->define_columns($columns);
        $this->define_headers($headers);

        // The name column is a header.
        $this->define_header_column('fullname');

        // Make this table sorted by last name by default.
        $this->sortable(true, 'lastname');

        $this->no_sorting('select');
        $this->no_sorting('sessions');
        $this->no_sorting('grades');
        $this->no_sorting('comments');
        $this->set_attribute('id', 'participants');

        get_parent_class(get_parent_class($this))::out($pagesize, $useinitialsbar, $downloadhelpbutton);
    }

    public function set_action($action) {
        $this->action = $action;
    }

    public function set_object($object) {
        $this->object = $object;
    }

    /**
     * Set filters and build table structure.
     *
     * @param filterset $filterset The filterset object to get the filters from.
     */
    public function set_filterset(filterset $filterset): void {
        global $DB;
        $otopoid = $filterset->get_filter('otopo')->current();
        $this->otopo = $DB->get_record('otopo', array('id' => $otopoid), '*', MUST_EXIST);
        $course = $DB->get_record('course', array('id' => $this->otopo->course), '*', MUST_EXIST);
        $this->cmid = get_coursemodule_from_instance('otopo', $this->otopo->id, $course->id, false, MUST_EXIST)->id;

        $modulecontext = \context_module::instance($this->cmid);
        $this->can_grade = has_capability('mod/otopo:grade', $modulecontext);

        // Process the filterset.
        parent::set_filterset($filterset);
    }

    /**
     * Guess the base url for the participants table.
     */
    public function guess_base_url(): void {
        $this->baseurl = new moodle_url('/mod/otopo/view.php', ['id' => $this->cmid, 'action' => $this->action, 'object' => $this->object]);
    }


    public function col_sessions($data) {
        if(!array_key_exists($data->id, $this->auto_grades)) {
            return '';
        }
        $sessions = '';
        if($this->otopo->session) {
            $sessions_ids = get_sessions($this->otopo);
        }
        //foreach($this->users_sessions_with_otopos[$data->id] as $session_id => $user_session) {
        foreach($this->auto_grades[$data->id] as $session_id => $grade) {
            $user_session = null;
            if(array_key_exists($data->id, $this->users_sessions_with_otopos) && array_key_exists($session_id, $this->users_sessions_with_otopos[$data->id])) {
                $user_session = $this->users_sessions_with_otopos[$data->id][$session_id];
            }
            if($this->otopo->session) {
                $i = 1;
                foreach(array_keys($sessions_ids) as $id) {
                    if($id == $session_id) {
                        $id_abs = $i;
                        break;
                    }
                    ++$i;
                }
            }
            else {
                $id_abs = abs($session_id);
            }
            $sessions .= '<div class="sessions" data-user="' . $data->id . '">';
            $sessions .= '<input type="checkbox" id="session' . $id_abs . '" value="' . $session_id . '">';
            $sessions .= '<label for="session' . $id_abs . '">&nbsp;';
            if($this->can_grade) {
                $sessions .= '<a ';
                if($user_session && !$user_session['validated']) {
                    $sessions .= 'class="text-muted" ';
                }
                $sessions .= 'href="' . new moodle_url('/mod/otopo/view.php?id='.$this->cmid.'&action=grader&user='.$data->id.'&session='.$session_id) . '">';
            }
            $sessions .= get_string('session', 'otopo') . ' ' . $id_abs;
            if($this->can_grade) {
                $sessions .= '</a>';
            }
            $sessions .= '</label><br></div>';
        }
        return $sessions;
    }

    public function col_grades($data) {
        if(!array_key_exists($data->id, $this->auto_grades)) {
            return '';
        }
        $grades = '';
        //foreach($this->users_sessions_with_otopos[$data->id] as $session_id => $user_session) {
        foreach($this->auto_grades[$data->id] as $session_id => $grade) {
            $user_session = null;
            if(array_key_exists($data->id, $this->users_sessions_with_otopos) && array_key_exists($session_id, $this->users_sessions_with_otopos[$data->id])) {
                $user_session = $this->users_sessions_with_otopos[$data->id][$session_id];
            }
            $classes = 'mb-2';
            if($user_session && !$user_session['validated']) {
                $classes .= ' text-muted';
            }
            if(array_key_exists($data->id, $this->graders)
               && array_key_exists($session_id, $this->graders[$data->id])
               && $this->graders[$data->id][$session_id]->grade) {
                $grades .= "<h5 class=\"" . $classes . "\">" . $this->graders[$data->id][$session_id]->grade . "</h5>";
            }
            else {
                $grades .= "<p class=\"" . $classes . "\">" . get_string('not_evaluated', 'otopo');
                if(array_key_exists($data->id, $this->auto_grades) && array_key_exists($session_id, $this->auto_grades[$data->id])) {
                    $grades .= " (" . $this->auto_grades[$data->id][$session_id] . ")";
                }
                $grades .= "</p>";
            }
        }
        return $grades;
    }

    public function col_comments($data) {
        if(!array_key_exists($data->id, $this->auto_grades)) {
            return '';
        }
        $comments = '';
        //foreach($this->users_sessions_with_otopos[$data->id] as $session_id => $user_session) {
        foreach($this->auto_grades[$data->id] as $session_id => $grade) {
            $user_session = null;
            if(array_key_exists($data->id, $this->users_sessions_with_otopos) && array_key_exists($session_id, $this->users_sessions_with_otopos[$data->id])) {
                $user_session = $this->users_sessions_with_otopos[$data->id][$session_id];
            }
            $classes = 'mb-2';
            if($user_session && !$user_session['validated']) {
                $classes .= ' text-muted';
            }
            if(array_key_exists($data->id, $this->graders)
               && array_key_exists($session_id, $this->graders[$data->id])
               && $this->graders[$data->id][$session_id]->comment) {
                $comments .= "<h5 class=\"" . $classes . "\">" . mb_strimwidth(strip_tags($this->graders[$data->id][$session_id]->comment), 0, 20, '...') . "</h5>";
            }
            else {
                $comments .= "<p class=\"" . $classes . "\">" . get_string('no_comments', 'otopo') . "</p>"; 
            }
        }
        return $comments;
    }

}
?>
