<?php
$services = array(
    'otoposervice' => array(                                                // the name of the web service
        'functions' => array ('mod_otopo_get_items'), // web service functions of this service
        'enabled' => 1,                                                       // if enabled, the service can be reachable on a default installation
        'downloadfiles' => 0,    // allow file downloads.
        'uploadfiles'  => 0      // allow file uploads.
    ),
    'otoposervice_admin' => array(                                                // the name of the web service
        'functions' => array (
            'mod_otopo_create_item',
            'mod_otopo_edit_item',
            'mod_otopo_delete_item',
            'mod_otopo_create_degree',
            'mod_otopo_edit_degree',
            'mod_otopo_delete_degree',
            'mod_otopo_get_group_chart',
            'mod_otopo_list_participants',
            'mod_otopo_get_participant',
            'mod_otopo_submit_grading_form'
        ), // web service functions of this service
        'requiredcapability' => 'mod/otopo:admin',                // if set, the web service user need this capability to access 
        'enabled' => 1,                                                       // if enabled, the service can be reachable on a default installation
        'downloadfiles' => 0,    // allow file downloads.
        'uploadfiles'  => 0      // allow file uploads.
    ),
    'otoposervice_user' => array(                                                // the name of the web service
        'functions' => array (
            'mod_otopo_get_user_otopo',
            'mod_otopo_set_user_otopo',
            'mod_otopo_get_my_evolution',
        ), // web service functions of this service
        'requiredcapability' => 'mod/otopo:fill',                // if set, the web service user need this capability to access 
        'enabled' => 1,                                                       // if enabled, the service can be reachable on a default installation
        'downloadfiles' => 0,    // allow file downloads.
        'uploadfiles'  => 0      // allow file uploads.
    )
);

$functions = array(
    'mod_otopo_get_items' => array(         //web service function name
        'classname'   => 'mod_otopo_external',  //class containing the external function OR namespaced class in classes/external/XXXX.php
        'methodname'  => 'get_items',          //external function name
        'classpath'   => 'mod/otopo/externallib.php',  //file containing the class/external function - not required if using namespaced auto-loading classes.
                                                   // defaults to the service's externalib.php
        'description' => 'Get all items of an Otopo activity.',    //human readable description of the web service function
        'type'        => 'read',                  //database rights of the web service function (read, write)
        'ajax' => true,        // is the service available to 'internal' ajax calls. 
        'services' => array(MOODLE_OFFICIAL_MOBILE_SERVICE),   // Optional, only available for Moodle 3.1 onwards. List of built-in services (by shortname) where the function will be included.  Services created manually via the Moodle interface are not supported.
        'capabilities' => '', // comma separated list of capabilities used by the function.
    ),
    'mod_otopo_create_item' => array(         //web service function name
        'classname'   => 'mod_otopo_external',  //class containing the external function OR namespaced class in classes/external/XXXX.php
        'methodname'  => 'create_item',          //external function name
        'classpath'   => 'mod/otopo/externallib.php',  //file containing the class/external function - not required if using namespaced auto-loading classes.
                                                   // defaults to the service's externalib.php
        'description' => 'Create item in an Otopo activity.',    //human readable description of the web service function
        'type'        => 'write',                  //database rights of the web service function (read, write)
        'ajax' => true,        // is the service available to 'internal' ajax calls. 
        'services' => array(MOODLE_OFFICIAL_MOBILE_SERVICE),   // Optional, only available for Moodle 3.1 onwards. List of built-in services (by shortname) where the function will be included.  Services created manually via the Moodle interface are not supported.
        'capabilities' => 'mod/otopo:admin', // comma separated list of capabilities used by the function.
    ),
    'mod_otopo_edit_item' => array(         //web service function name
        'classname'   => 'mod_otopo_external',  //class containing the external function OR namespaced class in classes/external/XXXX.php
        'methodname'  => 'edit_item',          //external function name
        'classpath'   => 'mod/otopo/externallib.php',  //file containing the class/external function - not required if using namespaced auto-loading classes.
                                                   // defaults to the service's externalib.php
        'description' => 'Edit item in an Otopo activity.',    //human readable description of the web service function
        'type'        => 'write',                  //database rights of the web service function (read, write)
        'ajax' => true,        // is the service available to 'internal' ajax calls. 
        'services' => array(MOODLE_OFFICIAL_MOBILE_SERVICE),   // Optional, only available for Moodle 3.1 onwards. List of built-in services (by shortname) where the function will be included.  Services editd manually via the Moodle interface are not supported.
        'capabilities' => 'mod/otopo:admin', // comma separated list of capabilities used by the function.
    ),
    'mod_otopo_delete_item' => array(         //web service function name
        'classname'   => 'mod_otopo_external',  //class containing the external function OR namespaced class in classes/external/XXXX.php
        'methodname'  => 'delete_item',          //external function name
        'classpath'   => 'mod/otopo/externallib.php',  //file containing the class/external function - not required if using namespaced auto-loading classes.
                                                   // defaults to the service's externalib.php
        'description' => 'Delete item in an Otopo activity.',    //human readable description of the web service function
        'type'        => 'write',                  //database rights of the web service function (read, write)
        'ajax' => true,        // is the service available to 'internal' ajax calls. 
        'services' => array(MOODLE_OFFICIAL_MOBILE_SERVICE),   // Optional, only available for Moodle 3.1 onwards. List of built-in services (by shortname) where the function will be included.  Services deleted manually via the Moodle interface are not supported.
        'capabilities' => 'mod/otopo:admin', // comma separated list of capabilities used by the function.
    ),
    'mod_otopo_create_degree' => array(         //web service function name
        'classname'   => 'mod_otopo_external',  //class containing the external function OR namespaced class in classes/external/XXXX.php
        'methodname'  => 'create_degree',          //external function name
        'classpath'   => 'mod/otopo/externallib.php',  //file containing the class/external function - not required if using namespaced auto-loading classes.
        // defaults to the service's externalib.php
        'description' => 'Create degree in an Otopo item.',    //human readable description of the web service function
        'type'        => 'write',                  //database rights of the web service function (read, write)
        'ajax' => true,        // is the service available to 'internal' ajax calls. 
        'services' => array(MOODLE_OFFICIAL_MOBILE_SERVICE),   // Optional, only available for Moodle 3.1 onwards. List of built-in services (by shortname) where the function will be included.  Services created manually via the Moodle interface are not supported.
        'capabilities' => 'mod/otopo:admin', // comma separated list of capabilities used by the function.
    ),
    'mod_otopo_edit_degree' => array(         //web service function name
        'classname'   => 'mod_otopo_external',  //class containing the external function OR namespaced class in classes/external/XXXX.php
        'methodname'  => 'edit_degree',          //external function name
        'classpath'   => 'mod/otopo/externallib.php',  //file containing the class/external function - not required if using namespaced auto-loading classes.
        // defaults to the service's externalib.php
        'description' => 'Edit degree in an Otopo item.',    //human readable description of the web service function
        'type'        => 'write',                  //database rights of the web service function (read, write)
        'ajax' => true,        // is the service available to 'internal' ajax calls. 
        'services' => array(MOODLE_OFFICIAL_MOBILE_SERVICE),   // Optional, only available for Moodle 3.1 onwards. List of built-in services (by shortname) where the function will be included.  Services editd manually via the Moodle interface are not supported.
        'capabilities' => 'mod/otopo:admin', // comma separated list of capabilities used by the function.
    ),
    'mod_otopo_delete_degree' => array(         //web service function name
        'classname'   => 'mod_otopo_external',  //class containing the external function OR namespaced class in classes/external/XXXX.php
        'methodname'  => 'delete_degree',          //external function name
        'classpath'   => 'mod/otopo/externallib.php',  //file containing the class/external function - not required if using namespaced auto-loading classes.
        // defaults to the service's externalib.php
        'description' => 'Delete degree in an Otopo item.',    //human readable description of the web service function
        'type'        => 'write',                  //database rights of the web service function (read, write)
        'ajax' => true,        // is the service available to 'internal' ajax calls. 
        'services' => array(MOODLE_OFFICIAL_MOBILE_SERVICE),   // Optional, only available for Moodle 3.1 onwards. List of built-in services (by shortname) where the function will be included.  Services deleted manually via the Moodle interface are not supported.
        'capabilities' => 'mod/otopo:admin', // comma separated list of capabilities used by the function.
    ),
    'mod_otopo_get_user_otopo' => array(         //web service function name
        'classname'   => 'mod_otopo_external',  //class containing the external function OR namespaced class in classes/external/XXXX.php
        'methodname'  => 'get_user_otopo',          //external function name
        'classpath'   => 'mod/otopo/externallib.php',  //file containing the class/external function - not required if using namespaced auto-loading classes.
                                                   // defaults to the service's externalib.php
        'description' => 'Get all my otopo in an Otopo activity for specific session.',    //human readable description of the web service function
        'type'        => 'read',                  //database rights of the web service function (read, write)
        'ajax' => true,        // is the service available to 'internal' ajax calls. 
        'services' => array(MOODLE_OFFICIAL_MOBILE_SERVICE),   // Optional, only available for Moodle 3.1 onwards. List of built-in services (by shortname) where the function will be included.  Services created manually via the Moodle interface are not supported.
        'capabilities' => 'mod/otopo:fill', // comma separated list of capabilities used by the function.
    ),
    'mod_otopo_set_user_otopo' => array(         //web service function name
        'classname'   => 'mod_otopo_external',  //class containing the external function OR namespaced class in classes/external/XXXX.php
        'methodname'  => 'set_user_otopo',          //external function name
        'classpath'   => 'mod/otopo/externallib.php',  //file containing the class/external function - not required if using namespaced auto-loading classes.
                                                   // defaults to the service's externalib.php
        'description' => 'Set my otopo in an Otopo activity for specific session/item.',    //human readable description of the web service function
        'type'        => 'write',                  //database rights of the web service function (read, write)
        'ajax' => true,        // is the service available to 'internal' ajax calls. 
        'services' => array(MOODLE_OFFICIAL_MOBILE_SERVICE),   // Optional, only available for Moodle 3.1 onwards. List of built-in services (by shortname) where the function will be included.  Services created manually via the Moodle interface are not supported.
        'capabilities' => 'mod/otopo:fill', // comma separated list of capabilities used by the function.
    ),
    'mod_otopo_get_group_chart' => array(         //web service function name
        'classname'   => 'mod_otopo_external',  //class containing the external function OR namespaced class in classes/external/XXXX.php
        'methodname'  => 'get_group_chart',          //external function name
        'classpath'   => 'mod/otopo/externallib.php',  //file containing the class/external function - not required if using namespaced auto-loading classes.
                                                   // defaults to the service's externalib.php
        'description' => 'Get chart data of Otopo activity.',    //human readable description of the web service function
        'type'        => 'read',                  //database rights of the web service function (read, write)
        'ajax' => true,        // is the service available to 'internal' ajax calls. 
        'services' => array(MOODLE_OFFICIAL_MOBILE_SERVICE),   // Optional, only available for Moodle 3.1 onwards. List of built-in services (by shortname) where the function will be included.  Services created manually via the Moodle interface are not supported.
        'capabilities' => 'mod/otopo:admin', // comma separated list of capabilities used by the function.
    ),
    'mod_otopo_get_my_evolution' => array(         //web service function name
        'classname'   => 'mod_otopo_external',  //class containing the external function OR namespaced class in classes/external/XXXX.php
        'methodname'  => 'get_my_evolution',          //external function name
        'classpath'   => 'mod/otopo/externallib.php',  //file containing the class/external function - not required if using namespaced auto-loading classes.
                                                   // defaults to the service's externalib.php
        'description' => 'Get my evolution.',    //human readable description of the web service function
        'type'        => 'read',                  //database rights of the web service function (read, write)
        'ajax' => true,        // is the service available to 'internal' ajax calls. 
        'services' => array(MOODLE_OFFICIAL_MOBILE_SERVICE),   // Optional, only available for Moodle 3.1 onwards. List of built-in services (by shortname) where the function will be included.  Services created manually via the Moodle interface are not supported.
        'capabilities' => 'mod/otopo:fill', // comma separated list of capabilities used by the function.
    ),
    'mod_otopo_list_participants' => array(         //web service function name
        'classname'   => 'mod_otopo_external',  //class containing the external function OR namespaced class in classes/external/XXXX.php
        'methodname'  => 'list_participants',          //external function name
        'classpath'   => 'mod/otopo/externallib.php',  //file containing the class/external function - not required if using namespaced auto-loading classes.
                                                   // defaults to the service's externalib.php
        'description' => 'Get participants.',    //human readable description of the web service function
        'type'        => 'read',                  //database rights of the web service function (read, write)
        'ajax' => true,        // is the service available to 'internal' ajax calls. 
        'services' => array(MOODLE_OFFICIAL_MOBILE_SERVICE),   // Optional, only available for Moodle 3.1 onwards. List of built-in services (by shortname) where the function will be included.  Services created manually via the Moodle interface are not supported.
        'capabilities' => 'mod/otopo:view', // comma separated list of capabilities used by the function.
    ),
    'mod_otopo_get_participant' => array(         //web service function name
        'classname'   => 'mod_otopo_external',  //class containing the external function OR namespaced class in classes/external/XXXX.php
        'methodname'  => 'get_participant',          //external function name
        'classpath'   => 'mod/otopo/externallib.php',  //file containing the class/external function - not required if using namespaced auto-loading classes.
                                                   // defaults to the service's externalib.php
        'description' => 'Get participant.',    //human readable description of the web service function
        'type'        => 'read',                  //database rights of the web service function (read, write)
        'ajax' => true,        // is the service available to 'internal' ajax calls. 
        'services' => array(MOODLE_OFFICIAL_MOBILE_SERVICE),   // Optional, only available for Moodle 3.1 onwards. List of built-in services (by shortname) where the function will be included.  Services created manually via the Moodle interface are not supported.
        'capabilities' => 'mod/otopo:view', // comma separated list of capabilities used by the function.
    ),
    'mod_otopo_submit_grading_form' => array(         //web service function name
        'classname'   => 'mod_otopo_external',  //class containing the external function OR namespaced class in classes/external/XXXX.php
        'methodname'  => 'submit_grading_form',          //external function name
        'classpath'   => 'mod/otopo/externallib.php',  //file containing the class/external function - not required if using namespaced auto-loading classes.
                                                   // defaults to the service's externalib.php
        'description' => 'Submit grading form.',    //human readable description of the web service function
        'type'        => 'write',                  //database rights of the web service function (read, write)
        'ajax' => true,        // is the service available to 'internal' ajax calls. 
        'services' => array(MOODLE_OFFICIAL_MOBILE_SERVICE),   // Optional, only available for Moodle 3.1 onwards. List of built-in services (by shortname) where the function will be included.  Services created manually via the Moodle interface are not supported.
        'capabilities' => 'mod/otopo:grade', // comma separated list of capabilities used by the function.
    ),
);
?>
