<?php

function xmldb_otopo_upgrade($oldversion) {
    global $CFG, $DB;

    $dbman = $DB->get_manager();

    if ($oldversion < 2022062101) {
        $table = new xmldb_table('otopo');
        $field = new xmldb_field('event', XMLDB_TYPE_INTEGER, '10', null, null, null, null);

        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        $table = new xmldb_table('otopo_session');

        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Assignment savepoint reached.
        upgrade_mod_savepoint(true, 2022062101, 'otopo');
    }

    if($oldversion < 2022070500) {
        $table = new xmldb_table('otopo');
        $field = new xmldb_field('event', XMLDB_TYPE_INTEGER, '10', null, null, null, null);
        $field_start = new xmldb_field('event_start', XMLDB_TYPE_INTEGER, '10', null, null, null, null);
        $field_end = new xmldb_field('event_end', XMLDB_TYPE_INTEGER, '10', null, null, null, null);

        if ($dbman->field_exists($table, $field)) {
            $dbman->drop_field($table, $field);
        }
        if (!$dbman->field_exists($table, $field_start)) {
            $dbman->add_field($table, $field_start);
        }
        if (!$dbman->field_exists($table, $field_end)) {
            $dbman->add_field($table, $field_end);
        }

        $table = new xmldb_table('otopo_session');

        if ($dbman->field_exists($table, $field)) {
            $dbman->drop_field($table, $field);
        }
        if (!$dbman->field_exists($table, $field_start)) {
            $dbman->add_field($table, $field_start);
        }
        if (!$dbman->field_exists($table, $field_end)) {
            $dbman->add_field($table, $field_end);
        }

        // Assignment savepoint reached.
        upgrade_mod_savepoint(true, 2022070500, 'otopo');
    }

    if ($oldversion < 2023020100) {

        $table = new xmldb_table('otopo_user_otopo');
        $field = new xmldb_field('user', XMLDB_TYPE_INTEGER, '10', null, XMLDB_NOTNULL, null, '0', 'id');
        $old_index = new xmldb_index('user', XMLDB_INDEX_NOTUNIQUE, ['user']);
        $index = new xmldb_index('userid', XMLDB_INDEX_NOTUNIQUE, ['userid']);

        // Drop old index
        if ($dbman->index_exists($table, $old_index)) {
            $dbman->drop_index($table, $old_index);
        }
        // Rename field
        $dbman->rename_field($table, $field, 'userid');
        // Create new index
        if (!$dbman->index_exists($table, $index)) {
            $dbman->add_index($table, $index);
        }

        $table = new xmldb_table('otopo_user_valid_session');

        // Drop old index
        if ($dbman->index_exists($table, $old_index)) {
            $dbman->drop_index($table, $old_index);
        }
        // Rename field
        $dbman->rename_field($table, $field, 'userid');
        // Create new index
        if (!$dbman->index_exists($table, $index)) {
            $dbman->add_index($table, $index);
        }

        $table = new xmldb_table('otopo_grader');

        // Drop old index
        if ($dbman->index_exists($table, $old_index)) {
            $dbman->drop_index($table, $old_index);
        }
        // Rename field
        $dbman->rename_field($table, $field, 'userid');
        // Create new index
        if (!$dbman->index_exists($table, $index)) {
            $dbman->add_index($table, $index);
        }

        // Otopo savepoint reached.
        upgrade_mod_savepoint(true, 2023020100, 'otopo');
    }

    return true;
}
?>
