<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'otopo', language 'en'
 *
 * @package   mod_otopo
 * @copyright  2022 Kosmos <contact@kosmos.fr>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
$string['pluginname'] = 'Otopo';
$string['modulename'] = 'Otopo';
$string['modulenameplural'] = 'Otopo';
$string['modulename_help'] = "The otopo activity module allows a teacher to create a repository from which students can self-assess at different times. The teacher will be able to comment on each self-assessment and follow its progress.";
$string['modulename_link'] = 'mod/otopo/view';
$string['pluginadministration'] = 'Otopo settings';

$string['deleteotopos'] = 'Delete all users otopos';
$string['deletegrader'] = 'Delete all teachers grades and comments';

$string['otopo:addinstance'] = "Add otopo activity";
$string['otopo:view'] = "Show the otopo activity";
$string['otopo:managetemplates'] = "Manage templates";
$string['otopo:admin'] = "Manage the activity";
$string['otopo:export_results'] = "Export results";
$string['otopo:fill'] = "Fill the activity";
$string['otopo:grade'] = "Evaluate the activity";
$string['otopo:receive_notifications'] = "Receive notifications";

$string['activity_viewed'] = "Activity viewed";
$string['activity_updated'] = "Activity updated";
$string['session_closed'] = "Session closed";
$string['session_saved'] = "Session saved";

$string['string_limit_255'] = "This field has a limit of 255 characters.";

$string['start'] = "Start";
$string['end'] = "End";

$string['edit'] = 'Edit';
$string['export_as_csv'] ="Export as CSV";
$string['save_as_template'] ="Save as template";
$string['save_items'] ="Save items";
$string['return_to_list'] ="Return to list";
$string['last_modification'] = "Last modification";
$string['pending'] = "Pending";
$string['closed'] = "Closed";
$string['validated'] = "Validated";
$string['not_validated'] = "Not validated";
$string['validate'] = "Validate";
$string['print'] = "Print";
$string['choose_session'] = "Choose session";
$string['choose_all'] = "Choose all";
$string['session_help'] = "If \"YES\" : the students will have to self-position themselves on the sessions you have defined, if \"NO\": the students will be able to self-position themselves as many times as they wish, within the limit of sessions defined.";
$string['validate_help'] = "Your changes are automatically saved. If you close you will no longer be able to modify your self-positioning on this session.";
$string['comment'] = "Comment";
$string['teacher_comment_global'] = "Teacher global comment";
$string['no_session'] = "No session";
$string['otopo_condition_completion'] = "Otopo condition";
$string['completionsubmit'] = "Show activity as complete as soon as OTOPO conditions are met
fulfilled.";
$string['completionsubmit_help'] = "If sessions are enabled, the activity is considered complete if the last session has been completed. If the sessions are disabled, the activity is considered complete if at least one self-positioning has been validated by the student.";
$string['activity_closed'] = "Activity closed.";

$string['menu_consult'] = 'Consult reports';
$string['menu_preview'] = 'Preview';
$string['menu_params'] = 'Settings';
$string['menu_sessions'] = 'Sessions';
$string['menu_grids'] = 'Grids';
$string['menu_templates'] = 'Templates';
$string['menu_individual_report'] = 'Individual report';
$string['menu_group_report'] = 'Group report';
$string['menu_session'] = 'Session';
$string['menu_grid'] = 'Grid';

$string['params_btn'] = 'Edit settings';

$string['name'] = 'Name';
$string['description'] = 'Description';
$string['showintro'] = 'Show description on course page';
$string['showteachercomments'] = 'Show teacher comments';
$string['grade'] = 'Grade';
$string['visual'] = 'Visualizations for associated stats';
$string['sessionvisual'] = 'Visualization for items and sessions';
$string['cohortvisual'] = 'Visualization for cohort';
$string['sessionoptions'] = 'Session options';
$string['session'] = 'Session';
$string['sessions'] = 'Session number';
$string['limit_sessions'] = 'Session number limit';
$string['gradeonlyforteacher'] = 'Hide grade for students';
$string['radar'] = 'Radar';
$string['bar'] = 'Bar';
$string['stackedbar'] = 'Stacked bar';
$string['disponibility'] = 'Disponibility';
$string['allowsubmissionfromdate'] = 'Allows answer from';
$string['allowsubmissiontodate'] = 'Allows answer to';
$string['allowsubmissiondateerror'] = 'Closing date can\'t be inferior to opening date';
$string['not_evaluated'] = 'Not evaluated';
$string['no_comments'] = 'No comments';
$string['sessions_comments'] = 'Sessions comments';
$string['student_distribution_by_item'] = 'Distribution of students by item';
$string['no_session_available'] = 'No auto-positionning session available';

$string['settings'] = 'Settings';
$string['default_showteachercomments'] = 'Show teacher comments default value';
$string['default_showteachercomments_desc'] = 'Allows you to change the default value for showing teacher comments on the creation of the activity';
$string['default_gradeonlyforteacher'] = 'Hide grade for students default value';
$string['default_gradeonlyforteacher_desc'] = 'Allows you to change the default value for hiding grade for students on the creation of the activity';
$string['default_sessionvisual'] = 'Vizualization for items and sessions default value';
$string['default_sessionvisual_desc'] = 'Allows you to change the default value for the vizualization for items and sessions default value on the creation of the activity';
$string['default_cohortvisual'] = 'Vizualization for cohort default value';
$string['default_cohortvisual_desc'] = 'Allows you to change the default value for the vizualization for cohort default value on the creation of the activity';
$string['default_sessions'] = 'Session number default value';
$string['default_sessions_desc'] = 'Allows you to change the default value for the number of sessions on the creation of the activity with session enabled';
$string['default_limit_sessions'] = 'Session number limit default value';
$string['default_limit_sessions_desc'] = 'Allows you to change the default value for the number of sessions limit on the creation of the activity';
$string['default_sessionscalendar'] = 'Sessions calendar';
$string['default_sessionscalendar_desc'] = 'Allow you to change the default behavior of the sessions calendar.';

$string['sessions_settings'] = 'Sessions auto-evaluation settings';
$string['session_name'] = 'Session name {no}';
$string['session_color'] = 'Session color {no}';
$string['session_allowsubmissionfromdate'] = 'Session allows answer from {no}';
$string['session_allowsubmissiontodate'] = 'Session allows answer to {no}';
$string['session_delete'] = 'Delete this session';
$string['session_add'] = 'Add a session';

$string['item_add_item'] = 'Add item';
$string['item_delete_item'] = 'Delete this item';
$string['item_choose_item_color'] = 'Choose item color';
$string['item_item'] = 'Item';
$string['item_degree'] = 'Degree';
$string['item_add_degree'] = 'Add a degree';
$string['item_delete_degree'] = 'Delete the degree';
$string['item_degree_grade'] = 'Degree grade';
$string['item_duplicate_item'] = 'Duplicate this item';

$string['autoeval'] = 'Auto-evaluation';
$string['autoevals_validated'] = 'Validated auto-evaluations';
$string['autoeval_desc'] = 'Estimate your progress for this item by clicking on the "+" and the "-". If you want more details, you can click on the "...".';
$string['autoeval_help'] = 'Help';
$string['autoeval_your_justification'] = 'Your justification...';
$string['autoeval_no_teacher_comment'] = 'Your teacher has not commented yet.';
$string['autoeval_modal_subtitle'] = 'Justify in few lines your positioning.';
$string['autoeval_modal_content'] = 'For example :';
$string['autoeval_modal_content1'] = 'Which tools used at which stage?';
$string['autoeval_modal_content2'] = 'Which methods used at which stage?';
$string['autoeval_degree'] = 'Degree';
$string['autoeval_description'] = 'Description';
$string['autoeval_i_autoeval'] = "I evaluate myself";
$string['autoeval_i_justify'] = "I justify mon positionning";
$string['autoeval_i_comments'] = "Comments of my teacher";

$string['grid_create_item'] = "Create/Edit grid";
$string['grid_create_from_template'] = "Create from template";
$string['grid_import_csv'] = "Import CSV";

$string['template'] = "Template";
$string['template_name'] = "Template name";
$string['template_choose_template'] = "Choose template";

$string['fill'] = "Self-evaluate";
$string['fill_intro'] = "You are about to start your self-assessment with OTOPO. You will find the general grid that you will use throughout this activity by clicking on the \"My general evaluation grid\" icon above. The elements of evaluation which will be proposed to you are made up of items with several levels of appreciation. It is up to you to estimate the level you have reached during your self-assessments.";
$string['fill_encouragement'] = "Good luck!";
$string['fill_my_progression'] = 'My progression';
$string['fill_my_evolution'] = 'My evolution';
$string['fill_my_grid'] = 'My evaluation general grid';
$string['fill_from'] = 'from';
$string['fill_to'] = 'to';
$string['fill_autoeval'] = 'My Auto-evaluation';

$string['evolution_choose_visual'] = "Choose a visualization";
$string['evolution_per_item'] = "Show my evolution per item";
$string['evolution_you_choose_for'] = "You choose for";

$string['viewreport'] = "Consult all reports";
