/**
 * Javascript to handle changing users via the user selector in the header.
 *
 * @module     mod_assign/grading_navigation
 * @package    mod_assign
 * @copyright  2016 Damyon Wiese <damyon@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @since      3.1
 */
define("mod_otopo/grading_navigation",["jquery","core/notification","core/str","core/form-autocomplete","core/ajax","mod_assign/grading_form_change_checker"],(function($,notification,str,autocomplete,ajax,checker){var GradingNavigation=function(selector){this._regionSelector=selector,this._region=$(selector),this._users=[],this._lastXofYUpdate=0,this._firstLoadUsers=!0,this._loadAllUsers(),this._region.find('[data-action="previous-user"]').on("click",this._handlePreviousUser.bind(this)),this._region.find('[data-action="next-user"]').on("click",this._handleNextUser.bind(this)),this._region.find('[data-action="change-user"]').on("change",this._handleChangeUser.bind(this)),$(document).on("user-changed",this._refreshSelector.bind(this)),$(document).on("done-saving-show-next",this._handleNextUser.bind(this));var userid=$('[data-region="grading-navigation-panel"]').data("first-userid");userid&&this._selectUserById(userid),str.get_string("changeuser","mod_assign").done((function(s){autocomplete.enhance("[data-action=change-user]",!1,"mod_otopo/participant_selector",s)})).fail(notification.exception),$(document).bind("start-loading-user",function(){this._isLoading=!0}.bind(this)),$(document).bind("finish-loading-user",function(){this._isLoading=!1}.bind(this))};return GradingNavigation.prototype._isLoading=!1,GradingNavigation.prototype._regionSelector=null,GradingNavigation.prototype._region=null,GradingNavigation.prototype._loadAllUsers=function(){var otopoid=this._region.find("[data-action=change-user]").attr("data-otopoid");return ajax.call([{methodname:"mod_otopo_list_participants",args:{otopo:otopoid,filter:""},done:this._usersLoaded.bind(this),fail:notification.exception}]),!0},GradingNavigation.prototype._usersLoaded=function(users){this._firstLoadUsers=!1,this._users=users,this._users.length?this._refreshCount():this._selectNoUser(),this._triggerNextUserEvent()},GradingNavigation.prototype._selectNoUser=function(){this._isLoading||(checker.checkFormForChanges('[data-region="grade-panel"] .gradeform')?str.get_strings([{key:"unsavedchanges",component:"mod_assign"},{key:"unsavedchangesquestion",component:"mod_assign"},{key:"saveandcontinue",component:"mod_assign"},{key:"cancel",component:"core"}]).done((function(strs){notification.confirm(strs[0],strs[1],strs[2],strs[3],(function(){$(document).trigger("save-changes",-1)}))})):$(document).trigger("user-changed",-1))},GradingNavigation.prototype._selectUserById=function(userid){var select=this._region.find("[data-action=change-user]"),useridnumber=parseInt(userid,10);this._isLoading||(checker.checkFormForChanges('[data-region="grade-panel"] .gradeform')?str.get_strings([{key:"unsavedchanges",component:"mod_assign"},{key:"unsavedchangesquestion",component:"mod_assign"},{key:"saveandcontinue",component:"mod_assign"},{key:"cancel",component:"core"}]).done((function(strs){notification.confirm(strs[0],strs[1],strs[2],strs[3],(function(){$(document).trigger("save-changes",useridnumber)}))})):(select.attr("data-selected",userid),!isNaN(useridnumber)&&useridnumber>0&&$(document).trigger("user-changed",userid)))},GradingNavigation.prototype._handlePreviousUser=function(e){e.preventDefault();var currentUserId=this._region.find("[data-action=change-user]").attr("data-selected"),i=0,currentIndex=0;for(i=0;i<this._users.length;i++)if(this._users[i].id==currentUserId){currentIndex=i;break}var count=this._users.length,newIndex=currentIndex-1;newIndex<0&&(newIndex=count-1),count&&this._selectUserById(this._users[newIndex].id)},GradingNavigation.prototype._handleNextUser=function(e,saved){e.preventDefault();var select=this._region.find("[data-action=change-user]"),currentUserId=select.attr("data-selected"),i=0,currentIndex=0;for(i=0;i<this._users.length;i++)if(this._users[i].id==currentUserId){currentIndex=i;break}var count=this._users.length,newIndex=(currentIndex+1)%count;if(saved&&count){var userid=this._users[newIndex].id,useridnumber=parseInt(userid,10);select.attr("data-selected",userid),!isNaN(useridnumber)&&useridnumber>0&&$(document).trigger("user-changed",userid)}else count&&this._selectUserById(this._users[newIndex].id)},GradingNavigation.prototype._setCountString=function(x,y){var updateNumber;this._lastXofYUpdate++,updateNumber=this._lastXofYUpdate;var param={x:x,y:y};str.get_string("xofy","mod_assign",param).done(function(s){updateNumber==this._lastXofYUpdate&&this._region.find('[data-region="user-count-summary"]').text(s)}.bind(this)).fail(notification.exception)},GradingNavigation.prototype._refreshCount=function(){var userid=this._region.find("[data-action=change-user]").attr("data-selected"),i=0,currentIndex=0;if(isNaN(userid)||userid<=0)this._region.find('[data-region="user-count"]').hide();else{for(this._region.find('[data-region="user-count"]').show(),i=0;i<this._users.length;i++)if(this._users[i].id==userid){currentIndex=i;break}var count=this._users.length;if(count&&(currentIndex+=1),this._setCountString(currentIndex,count),currentIndex>0){var url=new URL(window.location);url.searchParams.set("user",userid),window.history.replaceState({},"",url)}}},GradingNavigation.prototype._refreshSelector=function(event,userid){var select=this._region.find("[data-action=change-user]");userid=parseInt(userid,10),!isNaN(userid)&&userid>0&&select.attr("data-selected",userid),this._refreshCount()},GradingNavigation.prototype._triggerNextUserEvent=function(){this._users.length>1?$(document).trigger("next-user",{nextUserId:null,nextUser:!0}):$(document).trigger("next-user",{nextUser:!1})},GradingNavigation.prototype._handleChangeUser=function(){var select=this._region.find("[data-action=change-user]"),userid=parseInt(select.val(),10);this._isLoading||(checker.checkFormForChanges('[data-region="grade-panel"] .gradeform')?str.get_strings([{key:"unsavedchanges",component:"mod_assign"},{key:"unsavedchangesquestion",component:"mod_assign"},{key:"saveandcontinue",component:"mod_assign"},{key:"cancel",component:"core"}]).done((function(strs){notification.confirm(strs[0],strs[1],strs[2],strs[3],(function(){$(document).trigger("save-changes",userid)}))})):!isNaN(userid)&&userid>0&&(select.attr("data-selected",userid),$(document).trigger("user-changed",userid)))},GradingNavigation}));

//# sourceMappingURL=grading_navigation.min.js.map