define("mod_otopo/items/components/item",["exports","mod_otopo/items/store","mod_otopo/items/ajax","mod_otopo/items/components/degree","mod_otopo/color","mod_otopo/utils"],(function(_exports,_store,_ajax,_degree,_color,_utils){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function ownKeys(object,enumerableOnly){var keys=Object.keys(object);if(Object.getOwnPropertySymbols){var symbols=Object.getOwnPropertySymbols(object);enumerableOnly&&(symbols=symbols.filter((function(sym){return Object.getOwnPropertyDescriptor(object,sym).enumerable}))),keys.push.apply(keys,symbols)}return keys}function _objectSpread(target){for(var i=1;i<arguments.length;i++){var source=null!=arguments[i]?arguments[i]:{};i%2?ownKeys(Object(source),!0).forEach((function(key){_defineProperty(target,key,source[key])})):Object.getOwnPropertyDescriptors?Object.defineProperties(target,Object.getOwnPropertyDescriptors(source)):ownKeys(Object(source)).forEach((function(key){Object.defineProperty(target,key,Object.getOwnPropertyDescriptor(source,key))}))}return target}function _defineProperty(obj,key,value){return key in obj?Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}):obj[key]=value,obj}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_store=_interopRequireDefault(_store),_ajax=_interopRequireDefault(_ajax),_degree=_interopRequireDefault(_degree),_color=_interopRequireDefault(_color),_utils=_interopRequireDefault(_utils);var _default={components:{Degree:_degree.default,ColorPicker:_color.default},props:{otopo:{type:Number},item:{type:Object},index:{type:Number}},mounted:function(){this.$refs.name.focus()},data:function(){var _this=this;return{nbr:this.item.degrees.length,strings:this.$root.$data.strings,hasOtopo:this.$root.$data.hasOtopo,cmid:this.$root.$data.cmid,processChange:_utils.default.debounce((function(){return _this.saveItem()})),validated:!1,creationPending:!1,collapsed:!1,state:this.$root.$data.state}},methods:{deleteItem:function(){this.hasOtopo||(_store.default.deleteItem(this.index),_ajax.default.deleteItem(this.item.id,this.cmid))},duplicateItem:function(e){var _this2=this;if(e.preventDefault(),!this.hasOtopo){var item=_objectSpread({},this.item);item.degrees=[],this.item.degrees.forEach((function(degree){item.degrees.push(_objectSpread({},degree))})),delete item.id,item.degrees.forEach((function(degree){delete degree.id})),item.ord=this.item.ord+1,_store.default.addItemAfter(this.index,item).forEach((function(item){if(item.id){var itemToPersist=_objectSpread({},item);delete itemToPersist.degrees,_ajax.default.editItem(itemToPersist,_this2.cmid)}}));var itemToCreate=_objectSpread({},item);delete itemToCreate.degrees,_ajax.default.createItem(this.otopo,itemToCreate,this.cmid).then((function(itemId){item.id=itemId,item.degrees.forEach((function(degree){_ajax.default.createDegree(itemId,degree,_this2.cmid).then((function(degreeId){degree.id=degreeId}))}))}))}},addDegree:function(e){e.preventDefault(),this.hasOtopo||(_store.default.addDegreeToItem(this.item,{id:null,name:"",description:"",grade:this.nbr+1,ord:this.item.degrees.length>0?this.item.degrees[this.item.degrees.length-1].ord+1:0}),++this.nbr)},saveItem:function(){var _this3=this;if(this.validated=!0,this.$refs.formItem.checkValidity()){var item=_objectSpread({},this.item);delete item.degrees,item.id?_ajax.default.editItem(item,this.cmid):this.creationPending||(this.creationPending=!0,delete item.id,_ajax.default.createItem(this.otopo,item,this.cmid).then((function(itemId){_this3.item.id=itemId,_this3.creationPending=!1})))}},startDrag:function(evt,index){this.hasOtopo||(evt.dataTransfer.dropEffect="move",evt.dataTransfer.effectAllowed="move",evt.dataTransfer.setData("itemIndex",index),_store.default.startDraggingItem())},endDrag:function(){_store.default.stopDraggingItem()},onDrop:function(evt,before){var _this4=this;if(evt.preventDefault(),!this.hasOtopo){var itemIndex=parseInt(evt.dataTransfer.getData("itemIndex")),testItemIndex=before?itemIndex+1:itemIndex,testIndex=before?this.index:this.index+1;if(itemIndex!=this.index&&testItemIndex!=testIndex){var deletedItem=_store.default.deleteItem(itemIndex);if(deletedItem.ord=before?this.item.ord:this.item.ord+1,_store.default.addItemAfter(this.index,deletedItem).forEach((function(item){if(item.id){var itemToPersist=_objectSpread({},item);delete itemToPersist.degrees,_ajax.default.editItem(itemToPersist,_this4.cmid)}})),deletedItem.id){var deletedItemToPersist=_objectSpread({},deletedItem);delete deletedItemToPersist.degrees,_ajax.default.editItem(deletedItemToPersist,this.cmid)}}}},onDropDegree:function(evt){if(evt.preventDefault(),!this.hasOtopo){var degreeIndex=parseInt(evt.dataTransfer.getData("degreeIndex")),itemIndex=parseInt(evt.dataTransfer.getData("itemIndex")),deletedDegree=_store.default.deleteDegreeFromItem(this.$root.$data.state.items[itemIndex],degreeIndex);if(deletedDegree.ord=0,_store.default.addDegreeToItem(this.item,deletedDegree),deletedDegree.id){_ajax.default.deleteDegree(deletedDegree.id,this.cmid);var deletedDegreeToCreate=_objectSpread({},deletedDegree);delete deletedDegreeToCreate.id,_ajax.default.createDegree(this.item.id,deletedDegreeToCreate,this.cmid).then((function(degreeId){_store.default.degreeCreated(deletedDegree,degreeId)}))}}},collapse:function(e){e.preventDefault(),this.collapsed=!this.collapsed}},computed:{isDragging:function(){return this.state.draggingItem},isDraggingDegree:function(){return this.state.draggingDegree}},template:'\n<div class="item">\n    <div\n        class="drop-zone"\n        v-bind:class="{\'bg-otopo-light\': isDragging}"\n        @dragover.prevent\n        @dragenter.prevent\n        @drop="onDrop($event, true)">\n    </div>\n    <div\n        class="row border rounded bg-light pt-2"\n    >\n        <div\n            class="col-md-12"\n            draggable\n            @dragstart="startDrag($event, index)"\n            @dragend="endDrag"\n        >\n            <a class="dropdown-toggle nav-link drag-title" href="#" v-on:click="collapse">\n                <i class="icon fa fa-arrows"></i>\n                <label\n                    class="font-weight-bold text-dark"\n                    :for="\'item_name_\' + index"\n                >\n                    {{strings.item}} {{index+1}}\n                </label>\n            </a>\n        </div>\n        <div class="col-md-5" v-if="!collapsed">\n            <form ref="formItem" v-bind:class="{ \'was-validated\': validated }">\n            <div class="input-group mb-3">\n                <input\n                    v-model="item.name"\n                    ref="name"\n                    class="form-control"\n                    type="text"\n                    maxlength="255"\n                    :title="strings.string_limit_255"\n                    :id="\'item_name_\' + index"\n                    :disabled="creationPending"\n                    @input="processChange()"\n                    required\n                >\n            </div>\n            <label\n                class="font-weight-bold text-dark"\n                :for="\'item_color_\' + index"\n            >\n                {{strings.choose_item_color}}\n            </label>\n            <div class="input-group mb-3" :id="\'item_color_colorpicker_\' + index">\n                <ColorPicker\n                    :color="item.color"\n                    v-model="item.color"\n                    :id="\'item_color_\' + index"\n                    @input="processChange()"\n                    :disabled="creationPending"\n                    required\n                />\n            </div>\n            <button\n                v-on:click="duplicateItem"\n                :disabled="creationPending || hasOtopo"\n                class="btn btn-primary mt-2 mb-3"\n            >\n                {{ strings.duplicate_item }}\n            </button>\n            <button\n                v-on:click="deleteItem"\n                :disabled="creationPending || hasOtopo"\n                class="btn btn-danger mt-2 mb-3"\n            >\n                {{ strings.delete_item }}\n            </button>\n            </form>\n        </div>\n        <div class="col-md-7" v-if="!collapsed">\n            <Degree\n               v-for="(degree, degreeIndex) in item.degrees"\n               :key="degree.id ? degree.id : \'new_degree\' + degreeIndex"\n               :item="item"\n               :degree="degree"\n               :index="degreeIndex"\n               :itemIndex="index"\n            />\n            <a\n                v-on:click="addDegree"\n                :disabled="creationPending"\n                class="mt-2 mb-3 d-inline-block"\n                v-bind:class="{\'disabled\': hasOtopo}"\n                href="#"\n            >\n                + {{ strings.add_degree }}\n            </a>\n            <div\n                v-if="item.degrees.length === 0"\n                class="drop-zone"\n                v-bind:class="{\'bg-otopo-light\': isDraggingDegree}"\n                @dropover.prevent\n                @dragenter.prevent\n                @drop="onDropDegree($event)">\n            </div>\n        </div>\n    </div>\n    <div\n        class="drop-zone"\n        v-bind:class="{\'bg-otopo-light\': isDragging}"\n        @dragover.prevent\n        @dragenter.prevent\n        @drop="onDrop($event, false)">\n    </div>\n</div>\n'};return _exports.default=_default,_exports.default}));

//# sourceMappingURL=item.min.js.map