import Vue from 'vue';
import Items from 'mod_otopo/preview_sessions/components/items';
import * as ajaxItems from 'mod_otopo/items/ajax';
import * as ajaxOtopo from 'mod_otopo/otopo/ajax';
import utils from 'mod_otopo/utils';

export const init = (otopo, showComments, session, sessionValid, isOpen, starPng, starContainerPng, helpPng, plusPng, minusPng) => {
    var images = {
        'star': starPng,
        'starContainer': starContainerPng,
        'help': helpPng,
        'plus': plusPng,
        'minus': minusPng
    };


    ajaxItems.getItems(otopo).then((items) => {
        ajaxOtopo.getUserOtopo(otopo, session).then((otopos) => {
            const otoposO = {};
            otopos.forEach(o => {
                otoposO[o.item] = o;
                if(o.id === null && o.degree !== null) {
                    ajaxOtopo.setUserOtopo(otopo, session, o.item, o.degree, o.justification);
                }
            });
            utils.getAutoEvalStrings().then((strings) => {
                var app = new Vue({  // eslint-disable-line no-unused-vars
                    el: '#evaluate',
                    components: {
                        'Items': Items,
                    },
                    template: '<Items></Items>',
                    data: {
                        otopo: otopo,
                        showComments: showComments,
                        session: session,
                        active: !sessionValid && isOpen,
                        items: items,
                        strings: strings,
                        images: images,
                        otopos: otoposO
                    }
                });
            });
        });
    });
};
