var store = {
    state: {
        items: [],
        draggingItem: false,
        draggingDegree: false,
    },
    addItem (item) {
        this.state.items.push(item);
    },
    addItemAfter (index, item) {
        var itemsToPersist = [];
        this.state.items.splice(index, 0, item);
        if(this.state.items.length > index + 1 && this.state.items[index + 1].ord <= item.ord ) {
            var j = 1;
            for( var i = index + 1; i < this.state.items.length; i++) {
                this.state.items[i].ord = item.ord + j;
                itemsToPersist.push(this.state.items[i]);
                ++j;
            }
        }
        return itemsToPersist;
    },
    deleteItem (index) {
        var deletedItem = null;
        for( var i = 0; i < this.state.items.length; i++) {
            if ( i === index ) {
                deletedItem = this.state.items[i];
                this.state.items.splice(i, 1);
                break;
            }
        }
        return deletedItem;
    },
    addDegreeToItem (item, degree) {
        item.degrees.push(degree);
    },
    addDegreeToItemAfter (index, item, degree) {
        var degreesToPersist = [];
        item.degrees.splice(index, 0, degree);
        if(item.degrees.length > index + 1 && item.degrees[index + 1].ord <= degree.ord ) {
            var j = 1;
            for( var i = index + 1; i < item.degrees.length; i++) {
                item.degrees[i].ord = degree.ord + j;
                degreesToPersist.push(item.degrees[i]);
                ++j;
            }
        }
        return degreesToPersist;
    },
    deleteDegreeFromItem (item, degreeIndex) {
        var deletedDegree = null;
        for( var i = 0; i < item.degrees.length; i++) {
            if ( i === degreeIndex ) {
                deletedDegree = item.degrees[i];
                item.degrees.splice(i, 1);
                break;
            }
        }
        return deletedDegree;
    },
    startDraggingItem () {
        this.state.draggingItem = true;
    },
    stopDraggingItem () {
        this.state.draggingItem = false;
    },
    startDraggingDegree () {
        this.state.draggingDegree = true;
    },
    stopDraggingDegree () {
        this.state.draggingDegree = false;
    }
};

export default store;
