var DegreeModalHelp = {
    mounted () {
        document.body.classList.add('modal-open');
        var backdropDiv = document.createElement("div");
        backdropDiv.classList.add('modal-backdrop');
        backdropDiv.classList.add('fade');
        backdropDiv.classList.add('show');
        document.body.appendChild(backdropDiv);
    },
    destroyed () {
        document.body.classList.remove('modal-open');
        document.body.removeChild(document.body.lastChild);
    },
    data: function () {
        return {
            strings: this.$root.$data.strings,
        };
    },
    props: {
        itemName: {
            type: String,
        },
        color: {
            type: String,
        },
        degreeName: {
            type: String,
        },
        name: {
            type: String,
        },
        description: {
            type: String,
        }
    },
    template: `
<transition name="modal">
    <div class="modal fade show" tabindex="-1" role="dialog">
      <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content rounded">
          <div class="modal-header rounded-top">
            <button type="button" class="close close-modal" @click="$emit('close')" aria-label="Close">
                <i class="icon fa fa-times-circle" aria-hidden="true"></i>
            </button>
          </div>
          <div class="modal-body rounded-bottom otopo">
            <h5 class="font-weight-bold" :style="'color: ' + color + ';'">{{ itemName }}</h5>
            <h6 class="font-weight-bold">{{ degreeName }}</h6>
            <p>{{ name }}</p>
            <h6 class="font-weight-bold">{{ strings.description }}</h6>
            <p v-html="description"></p>
          </div>
        </div>
      </div>
    </div>
</transition>
`,
};

export default DegreeModalHelp;
