var ModalHelp = {
    mounted () {
        document.body.classList.add('modal-open');
        var backdropDiv = document.createElement("div");
        backdropDiv.classList.add('modal-backdrop');
        backdropDiv.classList.add('fade');
        backdropDiv.classList.add('show');
        document.body.appendChild(backdropDiv);
    },
    destroyed () {
        document.body.classList.remove('modal-open');
        document.body.removeChild(document.body.lastChild);
    },
    data: function () {
        return {
            strings: this.$root.$data.strings,
        };
    },
    template: `
<transition name="modal">
    <div class="modal fade show" tabindex="-1" role="dialog">
      <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content rounded">
          <div class="modal-header rounded-top bg-otopo text-uppercase text-center">
            <h5 class="modal-title w-100 font-weight-bold text-white">{{ strings.help }}</h5>
            <button type="button" class="close close-modal" @click="$emit('close')" aria-label="Close">
                <i class="icon fa fa-times-circle text-white" aria-hidden="true"></i>
            </button>
          </div>
          <div class="modal-body rounded-bottom otopo">
            <h5 class="font-weight-bold">{{ strings.modal_subtitle }}</h5>
            <p class="mt-2">{{ strings.modal_content }}
                <ul>
                    <li>{{ strings.modal_content1 }}</li>
                    <li>{{ strings.modal_content2 }}</li>
                </ul>
            </p>
          </div>
        </div>
      </div>
    </div>
</transition>
`,
};

export default ModalHelp;
