import Chart from 'core/chartjs';
import * as DynamicTable from 'core_table/dynamic';
import Ajax from 'core/ajax';

export const init = (uniqueid, wwwroot, moodlePre4) => {
    function export_csv(e) {
        e.preventDefault();
        const users = document.querySelector('#chart').dataset.users;
        const cmid = document.getElementById('export-csv').dataset.cmid;
        location.href = wwwroot + "/mod/otopo/view.php?id=" + cmid + "&action=export&object=group&users=" + users;
    }

    async function loadAjaxChart(otopo, users, session) {
        var promises = Ajax.call([
            {
                methodname: 'mod_otopo_get_group_chart', args: {
                    otopo: otopo,
                    users: users,
                    session: session
                }
            }
        ]);
        const chart = await promises[0];

        return chart;
    }

    function loadChart(otopo, users, session) {
        loadAjaxChart(otopo, users, session).then((chart) => {
            if(chart) {
                const config = {
                    data: chart,
                    options: {}
                };
                const legend = {
                    position: 'right',
                };
                const xScale = {
                    stacked: true,
                };
                const yScale = {
                    stacked: true,
                    ticks: {
                        min: 0,
                        max: 100,
                        stepSize: 10
                    }
                };
                if (moodlePre4) {
                    config.type = 'horizontalBar';
                    config.options.legend = legend;
                    config.options.scales = {
                        xAxes: [xScale],
                        yAxes: [yScale]
                    };
                    config.options.tooltips = {
                        callbacks: {
                            label: function (tooltipItem, data) {
                                let label = data.datasets[tooltipItem.datasetIndex].label || '';
                                label += ': ';
                                label += data.datasets[tooltipItem.datasetIndex].data[tooltipItem.index] || '0';
                                label += '%';
                                return label;
                            }
                        }
                    };
                } else {
                    config.type = 'bar';
                    config.options.indexAxis = 'y';
                    config.options.scales = {
                        x: xScale,
                        y: yScale
                    };
                    config.options.plugins = {};
                    config.options.plugins.legend = legend;
                    config.options.plugins.tooltip = {
                        callbacks: {
                            label: function (context) {
                                if (context) {
                                    let label = context.dataset.label || '';
                                    label += ': ';
                                    label += context.formattedValue || '0';
                                    label += '%';
                                    return label;
                                }
                            }
                        }
                    };
                }
                new Chart(
                    document.getElementById('chart'),
                    config
                );
            }
        });
    }

    const root = document.querySelector(`form[data-table-unique-id="${uniqueid}"]`);

    const otopo = root.dataset.otopo;
    const chart = document.getElementById('chart');
    if(chart) {
        const users = document.querySelector('#chart').dataset.users.split(',');
        const session = document.getElementById('session-selector')
              && parseInt(document.getElementById('session-selector').value) ?
              parseInt(document.getElementById('session-selector').value) : null;
        loadChart(otopo, users, session);
    }

    root.addEventListener(DynamicTable.Events.tableContentRefreshed, () => {
        const otopo = root.dataset.otopo;
        const chart = document.getElementById('chart');
        if(chart) {
            const users = document.querySelector('#chart').dataset.users.split(',');
            const session = document.getElementById('session-selector')
                  && parseInt(document.getElementById('session-selector').value) ?
                  parseInt(document.getElementById('session-selector').value) : null;
            if(users) {
                loadChart(otopo, users, session);
            }
        }
    });

    var lastWidth = 0;
    var lastHeight = 0;
    window.onbeforeprint = () => {
        for (var id in Chart.instances) {
            lastHeight = Chart.instances[id].canvas.parentNode.style.height;
            lastWidth = Chart.instances[id].canvas.parentNode.style.width;
            Chart.instances[id].canvas.parentNode.style.height = '1000px';
            Chart.instances[id].canvas.parentNode.style.width = '850px';
            Chart.instances[id].resize();
        }
    };
    window.addEventListener('afterprint', () => {
        for (var id in Chart.instances) {
            Chart.instances[id].canvas.parentNode.style.height = lastHeight;
            Chart.instances[id].canvas.parentNode.style.width = lastWidth;
            Chart.instances[id].resize();
        }
    });

    const exportCSVBtn = document.getElementById('export-csv');
    if(exportCSVBtn) {
        exportCSVBtn.onclick = function(e) {
            export_csv(e);
        };
    }
};
