export const init = (cmid, wwwroot) => {
    function getSessionsInputs() {
        return document.querySelectorAll(".sessions > input");
    }

    function getSessionsEnabled() {
        const sessions = [];
        const sessionsInputs = getSessionsInputs();
        for(var i = 0; i < sessionsInputs.length; i++) {
            if(sessionsInputs[i].checked) {
                sessions.push(sessionsInputs[i].parentNode.dataset.user + '_' + sessionsInputs[i].value);
            }
        }
        return sessions;
    }

    function toggleBtn() {
        const sessionsEnabled = getSessionsEnabled();
        const exportBtn = document.getElementById('export-csv');
        if(sessionsEnabled.length === 0) {
            exportBtn.classList.add('disabled');
        }
        else {
            exportBtn.classList.remove('disabled');
        }
    }

    toggleBtn();

    const sessionsInputs = getSessionsInputs();
    for(var i = 0; i < sessionsInputs.length; i++) {
        sessionsInputs[i].addEventListener('click', function() {
            toggleBtn();
        });
    }

    const exportBtn = document.getElementById('export-csv');
    exportBtn.addEventListener('click', function(e) {
        e.preventDefault();
        if(!exportBtn.classList.contains('disabled')) {
            const sessionsEnabled = getSessionsEnabled();
            location.href = wwwroot + "/mod/otopo/view.php?id=" + cmid + "&action=export&object=individual&sessions="
                + sessionsEnabled.join(',');
        }
    });
};
