<?php
namespace mod_otopo\table;

global $CFG;

require_once(__DIR__.'/../../locallib.php');
require_once($CFG->dirroot . '/course/modlib.php');

defined('MOODLE_INTERNAL') || die();

use core_table\dynamic as dynamic_table;
use core_table\local\filter\filterset;
use moodle_url;

class participants_no_row extends \core_user\table\participants implements dynamic_table {
    private $cmid;
    private $otopo;
    private $action;
    private $object;
    private $session;

    public function set_action($action) {
        $this->action = $action;
    }

    public function set_object($object) {
        $this->object = $object;
    }

    /**
     * Set filters and build table structure.
     *
     * @param filterset $filterset The filterset object to get the filters from.
     */
    public function set_filterset(filterset $filterset): void {
        global $DB;
        // Get the context.
        $otopoid = $filterset->get_filter('otopo')->current();
        $this->otopo = $DB->get_record('otopo', array('id' => $otopoid), '*', MUST_EXIST);
        $course = $DB->get_record('course', array('id' => $this->otopo->course), '*', MUST_EXIST);
        $this->cmid = get_coursemodule_from_instance('otopo', $this->otopo->id, $course->id, false, MUST_EXIST)->id;
        $this->session = $filterset->get_filter('session')->current();

        // Process the filterset.
        parent::set_filterset($filterset);
    }

    /**
     * Guess the base url for the participants table.
     */
    public function guess_base_url(): void {
        $this->baseurl = new moodle_url('/mod/otopo/view.php', ['id' => $this->cmid, 'action' => $this->action, 'object' => $this->object]);
    }

    public function build_table() {
        if ($this->rawdata instanceof \Traversable && !$this->rawdata->valid()) {
            return;
        }
        if (!$this->rawdata) {
            return;
        }
    }

    /**
     * This function is not part of the public api.
     */
    function print_nothing_to_display() {
        // Render the dynamic table header.
        echo $this->get_dynamic_table_html_start();

        // Render button to allow user to reset table preferences.
        echo $this->render_reset_button();

        $this->print_initials_bar();

        echo $this->print_chart();

        // Render the dynamic table footer.
        echo $this->get_dynamic_table_html_end();
    }

    function print_chart() {
        global $OUTPUT, $PAGE, $DB, $CFG;

        $get_id = function($user) {
            return $user->id;
        };
        $users = array_map($get_id, $this->rawdata);
        $users_ids = join(',', $users);

        if($this->session > 0) {
            $distribution = get_distribution_by_item($this->otopo, $users, $this->session);
        }
        else {
            $distribution = get_distribution_by_item($this->otopo, $users);
        }
        $items = get_items_sorted_from_otopo($this->otopo->id);

        $distribution_vis = [];
        $nbr_degrees_max = 0;
        foreach($items as $item) {
            if(count($item->degrees) > $nbr_degrees_max) {
                $nbr_degrees_max = count($item->degrees);
            }
        }
        foreach(array_values($items) as $key1 => $item) {
            for($i = 0; $i < $nbr_degrees_max; $i++) {
                if(!array_key_exists($i, $distribution_vis)) {
                    $distribution_vis[$i] = ['degree' => $i + 1, 'data' => []];
                }
                if(!array_key_exists($key1, $distribution_vis[$i]['data'])) {
                    $distribution_vis[$i]['data'][$key1] = ['value' => null];
                }
                if(array_key_exists($i, $distribution) && array_key_exists($key1, $distribution[$i])) {
                    $distribution_vis[$i]['data'][$key1]['value'] = $distribution[$i][$key1];
                }
            }
        }

        $index = 1;
        foreach ($items as $item) {
            $item->index = $index;
            ++$index;
        }

        // Needed because of a breaking change in chartJS 3 which is introduce in moodle 4
        $moodleVersion = get_config('')->version;
        if ($moodleVersion < 2022041906) {
            $moodlePre4 = true;
        } else {
            $moodlePre4 = false;
        }

        $course = $DB->get_record('course', array('id' => $this->otopo->course), '*', MUST_EXIST);
        $cm = get_coursemodule_from_instance('otopo', $this->otopo->id, $course->id, false, MUST_EXIST);
        $modulecontext = \context_module::instance($cm->id);

        $PAGE->requires->js_call_amd('mod_otopo/report_group', 'init', [$this->uniqueid, $CFG->wwwroot, $moodlePre4]);
        return $OUTPUT->render_from_template('mod_otopo/report_group', array('users' => $users_ids, 'distribution' => $distribution_vis, 'has_distribution' => !empty($distribution), 'items' => array_values($items), 'cmid' => $this->cmid, 'can_export_results' => has_capability('mod/otopo:export_results', $modulecontext)));
    }
}
?>
