<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Form to create/edit activity
 *
 * @package     mod_otopo
 * @copyright   2022 Kosmos <moodle@kosmos.fr>
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
if (!defined('MOODLE_INTERNAL')) {
    die('Direct access to this script is forbidden.');    ///  It must be included from a Moodle page
}

require_once($CFG->dirroot.'/course/moodleform_mod.php');
require_once($CFG->dirroot.'/mod/otopo/lib.php');

class mod_otopo_mod_form extends moodleform_mod {

    function definition() {
        global $CFG, $DB, $OUTPUT;

        $mform =& $this->_form;

        //-------------------------------------------------------------------------------
        $mform->addElement('header', 'general', get_string('general', 'form'));

        $mform->addElement('text', 'name', get_string('name', 'otopo'), array('size'=>'64'));
        $mform->setType('name', PARAM_TEXT);
        $mform->addRule('name', null, 'required', null, 'client');
        $mform->addRule('name', get_string('maximumchars', '', 255), 'maxlength', 255, 'client');

        $this->standard_intro_elements(get_string('description', 'otopo'));

        $mform->addElement('advcheckbox', 'showteachercomments', '', get_string('showteachercomments', 'otopo'), null, array(0, 1));
        $mform->setDefault('showteachercomments', get_config('mod_otopo', 'default_showteachercomments'));
        //-------------------------------------------------------------------------------

        //-------------------------------------------------------------------------------
        $this->standard_grading_coursemodule_elements();

        $mform->addElement('advcheckbox', 'gradeonlyforteacher', '', get_string('gradeonlyforteacher', 'otopo'), null, array(0, 1));
        $mform->setDefault('gradeonlyforteacher', get_config('mod_otopo', 'default_gradeonlyforteacher'));
        //-------------------------------------------------------------------------------

        //-------------------------------------------------------------------------------
        $mform->addElement('header', 'session_options', get_string('sessionoptions', 'otopo'));

        $mform->addElement('selectyesno', 'session', get_string('session', 'otopo'));
        $mform->addHelpButton('session', 'session', 'otopo');
        $mform->setDefault('session', 1);

        $mform->addElement('select', 'sessions', get_string('sessions', 'otopo'), array_slice(range(0, get_config('mod_otopo', 'default_limit_sessions')), 1, NULL, true), '');
        $mform->setDefault('sessions', get_config('mod_otopo', 'default_sessions'));
        $mform->hideIf('sessions', 'session', 'eq', 0);
        $mform->disabledIf('sessions', 'session', 'eq', 0);
        if ($this->current && $this->current->id) {
            $sessions = $DB->get_records('otopo_session', array('otopo' => $this->current->id), $sort = 'allowsubmissionfromdate', $fields = '*');
            if (count($sessions) > 0) {
                $mform->disabledIf('sessions', 'name', 'neq', '0');
            }
        }
        $mform->addElement('select', 'limit_sessions', get_string('limit_sessions', 'otopo'), array_slice(range(0, get_config('mod_otopo', 'default_limit_sessions')), 1, NULL, true), '');
        $mform->setDefault('limit_sessions', get_config('mod_otopo', 'default_limit_sessions'));
        $mform->hideIf('limit_sessions', 'session', 'eq', 1);
        $mform->disabledIf('limit_sessions', 'session', 'eq', 1);
        //-------------------------------------------------------------------------------

        //-------------------------------------------------------------------------------
        $mform->addElement('header', 'disponibility', get_string('disponibility', 'otopo'));
        $defaults_date = array(
            'optional' => true,
            'startyear' => 2020,
            'stopyear'  => 2040,
            'timezone'  => 99,
            'step'      => 5
        );

        $mform->addElement('date_time_selector', 'allowsubmissionfromdate', get_string('allowsubmissionfromdate', 'otopo'), $defaults_date);
        $mform->addElement('date_time_selector', 'allowsubmissiontodate', get_string('allowsubmissiontodate', 'otopo'), $defaults_date);
        if(get_config('mod_otopo', 'default_sessionscalendar')) {
            $mform->setDefault('allowsubmissionfromdate', time());
            $mform->setDefault('allowsubmissiontodate', time());
        }

        //-------------------------------------------------------------------------------

        //-------------------------------------------------------------------------------
        $mform->addElement('header', 'visual', get_string('visual', 'otopo'));

        $sessionVisuals = array();
        $sessionVisuals[] = $mform->createElement('radio', 'sessionvisual', '', '<img src="' . $OUTPUT->image_url('radar', 'mod_otopo') . '">', 0, array('class' => 'visual'));
        $sessionVisuals[] = $mform->createElement('radio', 'sessionvisual', '',  '<img src="' . $OUTPUT->image_url('bar', 'mod_otopo') . '">', 1, array('class' => 'visual'));
        $mform->addGroup($sessionVisuals, 'sessionvisual', get_string('sessionvisual', 'otopo'), array(' '), false);
        $mform->setDefault('sessionvisual', get_config('mod_otopo', 'default_sessionvisual'));

        $cohortVisuals = array();
        $cohortVisuals[] = $mform->createElement('radio', 'cohortvisual', '', '<img src="' . $OUTPUT->image_url('stacked_bar', 'mod_otopo') . '">', 0, array('class' => 'visual'));
        $mform->addGroup($cohortVisuals, 'cohortvisual', get_string('cohortvisual', 'otopo'), array(' '), false);
        $mform->setDefault('cohortvisual', get_config('mod_otopo', 'default_cohortvisual'));
        //-------------------------------------------------------------------------------

        //-------------------------------------------------------------------------------
        $this->standard_coursemodule_elements();
        $this->apply_admin_defaults();
        //-------------------------------------------------------------------------------

        $this->add_action_buttons();
    }

    function validation($data, $files) {
        if($data['allowsubmissionfromdate'] && $data['allowsubmissiontodate']
           && $data['allowsubmissionfromdate'] >= $data['allowsubmissiontodate'])
            return array('allowsubmissiontodate' => get_string('allowsubmissiondateerror', 'otopo'));
    }

    /**
     * Allows module to modify the data returned by form get_data().
     * This method is also called in the bulk activity completion form.
     *
     * Only available on moodleform_mod.
     *
     * @param stdClass $data the form data to be modified.
     */
    public function data_postprocessing($data) {
        parent::data_postprocessing($data);
        // Set up completion section even if checkbox is not ticked
        if (!empty($data->completionunlocked)) {
            if (empty($data->completionsubmit)) {
                $data->completionsubmit = 0;
            }
        }
    }

    function add_completion_rules() {
        $mform =& $this->_form;

        $mform->addElement('checkbox', 'completionsubmit', get_string('otopo_condition_completion', 'otopo'), get_string('completionsubmit', 'otopo'));
        $mform->addHelpButton('completionsubmit', 'completionsubmit', 'otopo');
        // Enable this completion rule by default.
        $mform->setDefault('completionsubmit', 1);
        return array('completionsubmit');
    }

    function completion_rule_enabled($data) {
        return !empty($data['completionsubmit']);
    }
}
?>
