import Ajax from 'core/ajax';

const ajax = {
    async getItems(otopo, cmid) {
        var promises = Ajax.call([{
            methodname: 'mod_otopo_get_items',
            args: {otopo: otopo, cmid: cmid},
        }]);
        var items = await promises[0];
        return items;
    },

    async createItem(otopo, item, cmid) {
        var promises = Ajax.call([{
            methodname: 'mod_otopo_create_item',
            args: {otopo: otopo, item: item, cmid: cmid},
        }]);
        var itemId = await promises[0];
        return itemId;
    },

    async editItem(item, cmid) {
        var promises = Ajax.call([{
            methodname: 'mod_otopo_edit_item',
            args: {item: item, cmid: cmid},
        }]);
        await promises[0];
    },

    async deleteItem(itemId, cmid) {
        var promises = Ajax.call([{
            methodname: 'mod_otopo_delete_item',
            args: {item_id: itemId, cmid: cmid},
        }]);
        await promises[0];
    },

    async createDegree(itemId, degree, cmid) {
        var promises = Ajax.call([{
            methodname: 'mod_otopo_create_degree',
            args: {item_id: itemId, degree: degree, cmid: cmid},
        }]);
        var degreeId = await promises[0];
        return degreeId;
    },

    async editDegree(degree, cmid) {
        var promises = Ajax.call([{
            methodname: 'mod_otopo_edit_degree',
            args: {degree: degree, cmid: cmid},
        }]);
        await promises[0];
    },

    async deleteDegree(degreeId, cmid) {
        var promises = Ajax.call([{
            methodname: 'mod_otopo_delete_degree',
            args: {degree_id: degreeId, cmid: cmid},
        }]);
        await promises[0];
    }
};

export default ajax;
